/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.jmx.internal;

import java.io.StringWriter;
import java.io.Writer;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularType;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.JSONString;
import org.apache.sling.commons.json.io.JSONWriter;

public class JsonOpenType {
    public String toJson(OpenType type) {
        if (type instanceof SimpleType) {
            return this.toJson((SimpleType)type);
        }
        if (type instanceof CompositeType) {
            return this.toJson((CompositeType)type);
        }
        if (type instanceof ArrayType) {
            return this.toJson((ArrayType)type);
        }
        if (type instanceof TabularType) {
            return this.toJson((TabularType)type);
        }
        throw new IllegalArgumentException("Unknown instance of open type: " + type.getClass().getName());
    }

    public String toJson(SimpleType type) {
        try {
            JSONObject o = new JSONObject();
            o.put("class", (Object)type.getClass().getName());
            o.put("className", (Object)type.getClassName());
            o.put("typeName", (Object)type.getTypeName());
            o.put("description", (Object)type.getDescription());
            return o.toString();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public String toJson(final CompositeType type) {
        try {
            StringWriter sw = new StringWriter();
            JSONWriter w = new JSONWriter((Writer)sw);
            w.object();
            w.key("class").value((Object)type.getClass().getName());
            w.key("className").value((Object)type.getClassName());
            w.key("typeName").value((Object)type.getTypeName());
            w.key("description").value((Object)type.getDescription());
            w.key("keys").array();
            for (String key1 : type.keySet()) {
                final String key = key1.toString();
                w.object();
                w.key("key").value((Object)key);
                w.key("description").value((Object)type.getDescription(key));
                w.key("type").value((Object)new JSONString(){

                    public String toJSONString() {
                        return JsonOpenType.this.toJson(type.getType(key));
                    }
                });
                w.endObject();
            }
            w.endArray();
            w.endObject();
            return sw.toString();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public String toJson(final ArrayType type) {
        try {
            JSONObject o = new JSONObject();
            o.put("class", (Object)type.getClass().getName());
            o.put("array", type.isArray());
            o.put("dimension", type.getDimension());
            o.put("className", (Object)type.getClassName());
            o.put("typeName", (Object)type.getTypeName());
            o.put("description", (Object)type.getDescription());
            o.put("elementOpenType", (Object)new JSONString(){

                public String toJSONString() {
                    return JsonOpenType.this.toJson(type.getElementOpenType());
                }
            });
            return o.toString();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public String toJson(final TabularType type) {
        try {
            StringWriter sw = new StringWriter();
            JSONWriter w = new JSONWriter((Writer)sw);
            w.object();
            w.key("class").value((Object)type.getClass().getName());
            w.key("className").value((Object)type.getClassName());
            w.key("typeName").value((Object)type.getTypeName());
            w.key("description").value((Object)type.getDescription());
            w.key("indexNames").array();
            for (String name : type.getIndexNames()) {
                w.value((Object)name.toString());
            }
            w.endArray();
            w.key("rowType").value((Object)new JSONString(){

                public String toJSONString() {
                    return JsonOpenType.this.toJson(type.getRowType());
                }
            });
            w.endObject();
            return sw.toString();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}

