/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.jmx.internal.editors;

import com.adobe.granite.jmx.internal.editors.CompositeEditor;
import com.adobe.granite.jmx.internal.editors.Editor;
import com.adobe.granite.jmx.internal.editors.EditorRegistry;
import com.adobe.granite.jmx.internal.editors.GenericJsonValue;
import com.adobe.granite.jmx.internal.editors.JsonValue;
import java.lang.reflect.Array;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.OpenType;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;

public class ArrayEditor
extends CompositeEditor {
    private ArrayType type;

    public ArrayEditor(EditorRegistry registry, ArrayType type) {
        super(registry);
        this.type = type;
    }

    public JsonValue asJsonValue(Object value) throws IllegalArgumentException {
        if (this.type.getDimension() > 1) {
            return new GenericJsonValue(ArrayUtils.toString((Object)value, (String)"null"));
        }
        int length = Array.getLength(value);
        Editor editor = this.registry.find(this.type.getElementOpenType());
        JSONArray a = new JSONArray();
        for (int i = 0; i < length; ++i) {
            Object itemValue = Array.get(value, i);
            JsonValue itemJsonValue = editor.asJsonValue(itemValue);
            a.put(itemJsonValue.value());
        }
        return new GenericJsonValue(a);
    }

    public Object parse(String text) throws IllegalArgumentException {
        OpenType<?> itemType = this.type.getElementOpenType();
        Editor editor = this.registry.find(itemType);
        try {
            JSONArray a = new JSONArray(text);
            Object array = Array.newInstance(this.registry.loadClass(itemType.getClassName()), a.length());
            for (int i = 0; i < a.length(); ++i) {
                Object item = a.get(i);
                Array.set(array, i, editor.parse(item.toString()));
            }
            return array;
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NegativeArraySizeException e) {
            throw new IllegalArgumentException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String asHtml(Object value) throws IllegalArgumentException {
        if (this.type.getDimension() > 1) {
            return StringEscapeUtils.escapeHtml4((String)ArrayUtils.toString((Object)value, (String)"<null>"));
        }
        int length = Array.getLength(value);
        Editor editor = this.registry.find(this.type.getElementOpenType());
        StringBuilder html = new StringBuilder();
        html.append("<ol>\n");
        for (int i = 0; i < length; ++i) {
            Object itemValue = Array.get(value, i);
            html.append("<li>");
            html.append(editor.asHtml(itemValue));
            html.append("</li>\n");
        }
        html.append("</ol>\n");
        return html.toString();
    }
}

