/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.jmx.internal.editors;

import com.adobe.granite.jmx.internal.editors.CompositeEditor;
import com.adobe.granite.jmx.internal.editors.Editor;
import com.adobe.granite.jmx.internal.editors.EditorRegistry;
import com.adobe.granite.jmx.internal.editors.GenericJsonValue;
import com.adobe.granite.jmx.internal.editors.JsonValue;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public class CompositeDataEditor
extends CompositeEditor {
    private CompositeType type;

    public CompositeDataEditor(EditorRegistry registry, CompositeType type) {
        super(registry);
        this.type = type;
    }

    public JsonValue asJsonValue(Object value) throws IllegalArgumentException {
        if (!(value instanceof CompositeData)) {
            throw new IllegalArgumentException("Value is not a CompositeData");
        }
        CompositeData data = (CompositeData)value;
        CompositeType type = data.getCompositeType();
        JSONObject o = new JSONObject();
        try {
            for (String key1 : type.keySet()) {
                String key = key1.toString();
                OpenType<?> itemType = type.getType(key);
                Object itemValue = data.get(key);
                Editor editor = this.registry.find(itemType);
                JsonValue itemJsonValue = editor.asJsonValue(itemValue);
                o.put(key, itemJsonValue.value());
            }
            return new GenericJsonValue(o);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Object parse(String text) throws IllegalArgumentException {
        LinkedHashMap<String, Object> items = new LinkedHashMap<String, Object>();
        try {
            JSONObject o = new JSONObject(text);
            Iterator it = o.keys();
            while (it.hasNext()) {
                String itemName = (String)it.next();
                Object item = o.get(itemName);
                OpenType<?> itemType = this.type.getType(itemName);
                Editor itemEditor = this.registry.find(itemType);
                items.put(itemName, itemEditor.parse(item.toString()));
            }
            return new CompositeDataSupport(this.type, items);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(e);
        }
        catch (OpenDataException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String asHtml(Object value) throws IllegalArgumentException {
        if (!(value instanceof CompositeData)) {
            throw new IllegalArgumentException("Value is not a CompositeData");
        }
        CompositeData data = (CompositeData)value;
        CompositeType type = data.getCompositeType();
        StringBuilder html = new StringBuilder();
        html.append("<table>\n");
        html.append("<caption>" + StringEscapeUtils.escapeHtml4((String)type.getTypeName()) + "</caption>\n");
        html.append("<tbody>\n");
        for (String key1 : type.keySet()) {
            String key = key1.toString();
            OpenType<?> itemType = type.getType(key);
            Object itemValue = data.get(key);
            html.append("<tr>\n");
            html.append("<td>");
            html.append(StringEscapeUtils.escapeHtml4((String)key));
            html.append("</td>\n");
            html.append("<td>");
            Editor editor = this.registry.find(itemType);
            html.append(editor.asHtml(itemValue));
            html.append("</td>\n");
            html.append("</tr>\n");
        }
        html.append("</tbody>\n");
        html.append("</table>\n");
        return html.toString();
    }
}

