/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.jmx.internal.editors;

import com.adobe.granite.jmx.internal.editors.Editor;
import com.adobe.granite.jmx.internal.editors.GenericJsonValue;
import com.adobe.granite.jmx.internal.editors.JsonValue;
import com.adobe.granite.jmx.internal.editors.PrimitiveArrayEditor;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class DateArrayEditor
extends PrimitiveArrayEditor {
    private static Editor instance;

    public static Editor getInstance() {
        if (instance == null) {
            instance = new DateArrayEditor();
        }
        return instance;
    }

    private DateArrayEditor() {
    }

    public JsonValue asJsonValue(Object value) throws IllegalArgumentException {
        int length = Array.getLength(value);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(df.format(Array.get(value, i)));
        }
        return new GenericJsonValue(sb.toString());
    }

    public Object parse(String text) throws IllegalArgumentException {
        String[] numbers = StringUtils.split((String)text, (String)", ".trim());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
        try {
            Date[] value = new Date[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                value[i] = df.parse(numbers[i].trim());
            }
            return value;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

