/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.jmx.internal.editors;

import com.adobe.granite.jmx.internal.editors.Editor;
import com.adobe.granite.jmx.internal.editors.GenericJsonValue;
import com.adobe.granite.jmx.internal.editors.JsonValue;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateEditor
implements Editor {
    public static final String FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static Editor instance;

    public static Editor getInstance() {
        if (instance == null) {
            instance = new DateEditor();
        }
        return instance;
    }

    private DateEditor() {
    }

    public JsonValue asJsonValue(Object value) throws IllegalArgumentException {
        if (!(value instanceof Date)) {
            throw new IllegalArgumentException("Value is not an instance of " + Date.class.getName());
        }
        SimpleDateFormat df = new SimpleDateFormat(FORMAT, Locale.US);
        return new GenericJsonValue(df.format(value));
    }

    public Object parse(String text) throws IllegalArgumentException {
        if (text == null || text.trim().length() == 0) {
            throw new IllegalArgumentException("Empty text");
        }
        SimpleDateFormat df = new SimpleDateFormat(FORMAT, Locale.US);
        try {
            return df.parse(text.trim());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String asHtml(Object value) throws IllegalArgumentException {
        if (value == null) {
            return "&lt;null&gt;";
        }
        if (!(value instanceof Date)) {
            throw new IllegalArgumentException("Value is not an instance of " + Date.class.getName());
        }
        SimpleDateFormat df = new SimpleDateFormat(FORMAT, Locale.US);
        return df.format(value);
    }
}

