/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.jmx.internal.editors;

import com.adobe.granite.jmx.internal.editors.ArrayEditor;
import com.adobe.granite.jmx.internal.editors.BigDecimalArrayEditor;
import com.adobe.granite.jmx.internal.editors.BigDecimalEditor;
import com.adobe.granite.jmx.internal.editors.BigIntegerArrayEditor;
import com.adobe.granite.jmx.internal.editors.BigIntegerEditor;
import com.adobe.granite.jmx.internal.editors.BooleanArrayEditor;
import com.adobe.granite.jmx.internal.editors.BooleanEditor;
import com.adobe.granite.jmx.internal.editors.ByteArrayEditor;
import com.adobe.granite.jmx.internal.editors.ByteEditor;
import com.adobe.granite.jmx.internal.editors.CharacterArrayEditor;
import com.adobe.granite.jmx.internal.editors.CharacterEditor;
import com.adobe.granite.jmx.internal.editors.CompositeDataEditor;
import com.adobe.granite.jmx.internal.editors.DateArrayEditor;
import com.adobe.granite.jmx.internal.editors.DateEditor;
import com.adobe.granite.jmx.internal.editors.DoubleArrayEditor;
import com.adobe.granite.jmx.internal.editors.DoubleEditor;
import com.adobe.granite.jmx.internal.editors.Editor;
import com.adobe.granite.jmx.internal.editors.FloatArrayEditor;
import com.adobe.granite.jmx.internal.editors.FloatEditor;
import com.adobe.granite.jmx.internal.editors.IntegerArrayEditor;
import com.adobe.granite.jmx.internal.editors.IntegerEditor;
import com.adobe.granite.jmx.internal.editors.LongArrayEditor;
import com.adobe.granite.jmx.internal.editors.LongEditor;
import com.adobe.granite.jmx.internal.editors.ObjectNameEditor;
import com.adobe.granite.jmx.internal.editors.PrimitiveBooleanArrayEditor;
import com.adobe.granite.jmx.internal.editors.PrimitiveByteArrayEditor;
import com.adobe.granite.jmx.internal.editors.PrimitiveCharacterArrayEditor;
import com.adobe.granite.jmx.internal.editors.PrimitiveDoubleArrayEditor;
import com.adobe.granite.jmx.internal.editors.PrimitiveFloatArrayEditor;
import com.adobe.granite.jmx.internal.editors.PrimitiveIntegerArrayEditor;
import com.adobe.granite.jmx.internal.editors.PrimitiveLongArrayEditor;
import com.adobe.granite.jmx.internal.editors.PrimitiveShortArrayEditor;
import com.adobe.granite.jmx.internal.editors.ShortArrayEditor;
import com.adobe.granite.jmx.internal.editors.ShortEditor;
import com.adobe.granite.jmx.internal.editors.StringArrayEditor;
import com.adobe.granite.jmx.internal.editors.StringEditor;
import com.adobe.granite.jmx.internal.editors.TabularDataEditor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EditorRegistry {
    private static final Editor DEFAULT = StringEditor.getInstance();

    public Editor find(String className) {
        if (className.equals(BigDecimal.class.getName())) {
            return BigDecimalEditor.getInstance();
        }
        if (className.equals(BigDecimal[].class.getName())) {
            return BigDecimalArrayEditor.getInstance();
        }
        if (className.equals(BigInteger.class.getName())) {
            return BigIntegerEditor.getInstance();
        }
        if (className.equals(BigInteger[].class.getName())) {
            return BigIntegerArrayEditor.getInstance();
        }
        if (className.equals(Boolean.TYPE.getName()) || className.equals(Boolean.class.getName())) {
            return BooleanEditor.getInstance();
        }
        if (className.equals(boolean[].class.getName())) {
            return PrimitiveBooleanArrayEditor.getInstance();
        }
        if (className.equals(Boolean[].class.getName())) {
            return BooleanArrayEditor.getInstance();
        }
        if (className.equals(Byte.TYPE.getName()) || className.equals(Byte.class.getName())) {
            return ByteEditor.getInstance();
        }
        if (className.equals(byte[].class.getName())) {
            return PrimitiveByteArrayEditor.getInstance();
        }
        if (className.equals(Byte[].class.getName())) {
            return ByteArrayEditor.getInstance();
        }
        if (className.equals(Character.TYPE.getName()) || className.equals(Character.class.getName())) {
            return CharacterEditor.getInstance();
        }
        if (className.equals(char[].class.getName())) {
            return PrimitiveCharacterArrayEditor.getInstance();
        }
        if (className.equals(Character[].class.getName())) {
            return CharacterArrayEditor.getInstance();
        }
        if (className.equals(Date.class.getName())) {
            return DateEditor.getInstance();
        }
        if (className.equals(Date[].class.getName())) {
            return DateArrayEditor.getInstance();
        }
        if (className.equals(Double.TYPE.getName()) || className.equals(Double.class.getName())) {
            return DoubleEditor.getInstance();
        }
        if (className.equals(double[].class.getName())) {
            return PrimitiveDoubleArrayEditor.getInstance();
        }
        if (className.equals(Double[].class.getName())) {
            return DoubleArrayEditor.getInstance();
        }
        if (className.equals(Float.TYPE.getName()) || className.equals(Float.class.getName())) {
            return FloatEditor.getInstance();
        }
        if (className.equals(float[].class.getName())) {
            return PrimitiveFloatArrayEditor.getInstance();
        }
        if (className.equals(Float[].class.getName())) {
            return FloatArrayEditor.getInstance();
        }
        if (className.equals(Integer.TYPE.getName()) || className.equals(Integer.class.getName())) {
            return IntegerEditor.getInstance();
        }
        if (className.equals(int[].class.getName())) {
            return PrimitiveIntegerArrayEditor.getInstance();
        }
        if (className.equals(Integer[].class.getName())) {
            return IntegerArrayEditor.getInstance();
        }
        if (className.equals(Long.TYPE.getName()) || className.equals(Long.class.getName())) {
            return LongEditor.getInstance();
        }
        if (className.equals(long[].class.getName())) {
            return PrimitiveLongArrayEditor.getInstance();
        }
        if (className.equals(Long[].class.getName())) {
            return LongArrayEditor.getInstance();
        }
        if (className.equals(ObjectName.class.getName())) {
            return ObjectNameEditor.getInstance();
        }
        if (className.equals(Short.TYPE.getName()) || className.equals(Short.class.getName())) {
            return ShortEditor.getInstance();
        }
        if (className.equals(short[].class.getName())) {
            return PrimitiveShortArrayEditor.getInstance();
        }
        if (className.equals(Short[].class.getName())) {
            return ShortArrayEditor.getInstance();
        }
        if (className.equals(String.class.getName())) {
            return StringEditor.getInstance();
        }
        if (className.equals(String[].class.getName())) {
            return StringArrayEditor.getInstance();
        }
        return null;
    }

    public Editor find(OpenType type) {
        if (type instanceof CompositeType) {
            return new CompositeDataEditor(this, (CompositeType)type);
        }
        if (type instanceof TabularType) {
            return new TabularDataEditor(this, (TabularType)type);
        }
        if (type instanceof ArrayType) {
            return new ArrayEditor(this, (ArrayType)type);
        }
        if (type instanceof SimpleType) {
            return this.find(type.getClassName());
        }
        return null;
    }

    public Editor find(MBeanAttributeInfo info) {
        Editor editor = null;
        if (info instanceof OpenMBeanAttributeInfo) {
            OpenMBeanAttributeInfo openInfo = (OpenMBeanAttributeInfo)((Object)info);
            editor = this.find(openInfo.getOpenType());
        } else {
            editor = this.find(info.getType());
        }
        if (editor == null) {
            editor = DEFAULT;
        }
        return editor;
    }

    public Editor find(MBeanAttributeInfo info, Object value) {
        Editor editor = null;
        if (info instanceof OpenMBeanAttributeInfo) {
            OpenMBeanAttributeInfo openInfo = (OpenMBeanAttributeInfo)((Object)info);
            editor = this.find(openInfo.getOpenType());
        } else {
            if (value instanceof CompositeData) {
                return new CompositeDataEditor(this, ((CompositeData)value).getCompositeType());
            }
            if (value instanceof TabularData) {
                return new TabularDataEditor(this, ((TabularData)value).getTabularType());
            }
            editor = this.find(info.getType());
        }
        if (editor == null) {
            editor = DEFAULT;
        }
        return editor;
    }

    public Editor find(MBeanParameterInfo info) {
        Editor editor = null;
        if (info instanceof OpenMBeanParameterInfo) {
            OpenMBeanParameterInfo openInfo = (OpenMBeanParameterInfo)((Object)info);
            editor = this.find(openInfo.getOpenType());
        } else {
            editor = this.find(info.getType());
        }
        if (editor == null) {
            editor = DEFAULT;
        }
        return editor;
    }

    public Editor find(MBeanOperationInfo info, Object value) {
        Editor editor = null;
        if (info instanceof OpenMBeanOperationInfo) {
            OpenMBeanOperationInfo openInfo = (OpenMBeanOperationInfo)((Object)info);
            editor = this.find(openInfo.getReturnOpenType());
        } else {
            if (value instanceof CompositeData) {
                return new CompositeDataEditor(this, ((CompositeData)value).getCompositeType());
            }
            if (value instanceof TabularData) {
                return new TabularDataEditor(this, ((TabularData)value).getTabularType());
            }
            editor = this.find(info.getReturnType());
        }
        if (editor == null) {
            editor = DEFAULT;
        }
        return editor;
    }

    public boolean isEditable(MBeanAttributeInfo info) {
        if (info instanceof OpenMBeanAttributeInfo) {
            return true;
        }
        return this.find(info.getType()) != null;
    }

    public boolean isEditable(MBeanParameterInfo info) {
        if (info instanceof OpenMBeanParameterInfo) {
            return true;
        }
        return this.find(info.getType()) != null;
    }

    public abstract Class<?> loadClass(String var1) throws ClassNotFoundException;
}

