/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.jmx.internal.editors;

import com.adobe.granite.jmx.internal.editors.Editor;
import com.adobe.granite.jmx.internal.editors.GenericJsonValue;
import com.adobe.granite.jmx.internal.editors.JsonValue;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringEscapeUtils;

public class ObjectNameEditor
implements Editor {
    private static Editor instance;

    public static Editor getInstance() {
        if (instance == null) {
            instance = new ObjectNameEditor();
        }
        return instance;
    }

    private ObjectNameEditor() {
    }

    public JsonValue asJsonValue(Object value) throws IllegalArgumentException {
        if (!(value instanceof ObjectName)) {
            throw new IllegalArgumentException("Value is not an instance of " + ObjectName.class.getName());
        }
        return new GenericJsonValue(((ObjectName)value).getCanonicalName());
    }

    public Object parse(String text) throws IllegalArgumentException {
        try {
            return new ObjectName(text);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String asHtml(Object value) throws IllegalArgumentException {
        if (value == null) {
            return StringEscapeUtils.escapeHtml4((String)"<null>");
        }
        if (!(value instanceof ObjectName)) {
            throw new IllegalArgumentException("Value is not an instance of " + ObjectName.class.getName());
        }
        return StringEscapeUtils.escapeHtml4((String)((ObjectName)value).getCanonicalName());
    }
}

