/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.jmx.internal.editors;

import com.adobe.granite.jmx.internal.editors.Editor;
import com.adobe.granite.jmx.internal.editors.GenericJsonValue;
import com.adobe.granite.jmx.internal.editors.JsonValue;
import java.lang.reflect.Array;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;

public class StringArrayEditor
implements Editor {
    private static Editor instance;

    public static Editor getInstance() {
        if (instance == null) {
            instance = new StringArrayEditor();
        }
        return instance;
    }

    private StringArrayEditor() {
    }

    public JsonValue asJsonValue(Object value) throws IllegalArgumentException {
        int length = Array.getLength(value);
        JSONArray a = new JSONArray();
        for (int i = 0; i < length; ++i) {
            a.put(Array.get(value, i));
        }
        return new GenericJsonValue(a);
    }

    public Object parse(String text) throws IllegalArgumentException {
        try {
            JSONArray a = new JSONArray(text);
            String[] results = new String[a.length()];
            for (int i = 0; i < a.length(); ++i) {
                results[i] = a.get(i).toString();
            }
            return results;
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String asHtml(Object value) throws IllegalArgumentException {
        int length = Array.getLength(value);
        StringBuilder html = new StringBuilder();
        html.append("<ol>\n");
        for (int i = 0; i < length; ++i) {
            html.append("<li>");
            html.append(StringEscapeUtils.escapeHtml4((String)Array.get(value, i).toString()));
            html.append("</li>\n");
        }
        html.append("</ol>\n");
        return html.toString();
    }
}

