/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.jmx.internal.editors;

import com.adobe.granite.jmx.internal.editors.CompositeEditor;
import com.adobe.granite.jmx.internal.editors.Editor;
import com.adobe.granite.jmx.internal.editors.EditorRegistry;
import com.adobe.granite.jmx.internal.editors.GenericJsonValue;
import com.adobe.granite.jmx.internal.editors.JsonValue;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.sling.commons.json.JSONArray;

public class TabularDataEditor
extends CompositeEditor {
    private TabularType type;

    public TabularDataEditor(EditorRegistry registry, TabularType type) {
        super(registry);
        this.type = type;
    }

    public JsonValue asJsonValue(Object value) throws IllegalArgumentException {
        if (!(value instanceof TabularData)) {
            throw new IllegalArgumentException("Value is not a TabularData");
        }
        TabularData data = (TabularData)value;
        TabularType type = data.getTabularType();
        CompositeType itemType = type.getRowType();
        Editor itemEditor = this.registry.find(itemType);
        JSONArray a = new JSONArray();
        for (Object item : data.values()) {
            JsonValue itemJsonValue = itemEditor.asJsonValue(item);
            a.put(itemJsonValue.value());
        }
        return new GenericJsonValue(a);
    }

    public Object parse(String text) throws IllegalArgumentException {
        CompositeType itemType = this.type.getRowType();
        TabularDataSupport data = new TabularDataSupport(this.type);
        try {
            JSONArray a = new JSONArray(text);
            for (int i = 0; i < a.length(); ++i) {
                Object item = a.get(i);
                Editor itemEditor = this.registry.find(itemType);
                Object itemValue = itemEditor.parse(item.toString());
                data.put((CompositeData)itemValue);
            }
            return data;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String asHtml(Object value) throws IllegalArgumentException {
        if (!(value instanceof TabularData)) {
            throw new IllegalArgumentException("Value is not a TabularData");
        }
        TabularData data = (TabularData)value;
        TabularType type = data.getTabularType();
        StringBuilder html = new StringBuilder();
        html.append("<table>\n");
        html.append("<caption>" + StringEscapeUtils.escapeHtml4((String)type.getTypeName()) + "</caption>\n");
        html.append("<thead><tr>\n");
        for (String s : type.getRowType().keySet()) {
            html.append("<td class='ui-widget-header'>");
            html.append(StringEscapeUtils.escapeHtml4((String)s.toString()));
            html.append("</td>\n");
        }
        html.append("</tr></thead>\n");
        html.append("<tbody>\n");
        for (String o : data.values()) {
            this.appendRow((CompositeData)((Object)o), html);
        }
        html.append("<tbody>\n");
        html.append("</table>\n");
        return html.toString();
    }

    private void appendRow(CompositeData data, StringBuilder html) {
        CompositeType type = data.getCompositeType();
        html.append("<tr>\n");
        for (String key1 : type.keySet()) {
            String itemName = key1.toString();
            OpenType<?> itemType = type.getType(itemName);
            Object itemValue = data.get(itemName);
            html.append("<td>");
            Editor editor = this.registry.find(itemType);
            html.append(editor.asHtml(itemValue));
            html.append("</td>\n");
        }
        html.append("</tr>\n");
    }
}

