/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.jmx.internal;

import com.adobe.granite.jmx.internal.JMXConsolePlugin;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import org.apache.felix.webconsole.ConfigurationPrinter;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.PrettyPrinter;
import org.codehaus.jackson.util.DefaultPrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXConfigurationPrinter
implements ConfigurationPrinter {
    private static final String TITLE = "JMX";
    private JsonFactory jsonFactory = new JsonFactory();
    private MBeanServerConnection server = ManagementFactory.getPlatformMBeanServer();
    private SimpleDateFormat dateFormat = new SimpleDateFormat();

    public String getTitle() {
        return TITLE;
    }

    public void printConfiguration(PrintWriter writer) {
        Set<ObjectName> objectNames = null;
        try {
            objectNames = this.server.queryNames(null, null);
        }
        catch (IOException e) {
            this.handleException(e, "Error in querying MBeans", writer);
            return;
        }
        Set<ObjectName> sortedObjectNames = this.retrieveSortedObjectNames(objectNames);
        try {
            JsonGenerator jsonGenerator = this.createJsonGenerator();
            jsonGenerator.writeStartObject();
            this.writeNumberOfMBeans(sortedObjectNames.size(), jsonGenerator);
            this.writeMBeans(sortedObjectNames, jsonGenerator);
            jsonGenerator.writeEndObject();
            this.writeGeneratedJson(writer, jsonGenerator);
        }
        catch (Exception e) {
            this.handleException(e, "Error in generating JSON for MBeans", writer);
            return;
        }
    }

    private JsonGenerator createJsonGenerator() throws IOException {
        JsonGenerator jasonGenerator = this.jsonFactory.createJsonGenerator((Writer)new StringWriter());
        jasonGenerator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
        return jasonGenerator;
    }

    private void handleException(Exception e, String message, PrintWriter writer) {
        writer.println(message + ": " + e.getMessage());
        e.printStackTrace(writer);
    }

    private Set<ObjectName> retrieveSortedObjectNames(Set<ObjectName> objectNames) {
        TreeSet<ObjectName> sortedObjectNames = new TreeSet<ObjectName>(JMXConsolePlugin.OBJECT_NAME_COMPERATOR);
        for (ObjectName objectName : objectNames) {
            sortedObjectNames.add(objectName);
        }
        return sortedObjectNames;
    }

    private void writeNumberOfMBeans(int numberOfBeans, JsonGenerator jsonGenerator) throws Exception {
        jsonGenerator.writeNumberField("NumberOfMBeans", numberOfBeans);
        jsonGenerator.writeStringField("Timestamp", this.dateFormat.format(new Date()));
    }

    private void writeMBeans(Set<ObjectName> sortedObjectNames, JsonGenerator jsonGenerator) throws Exception {
        jsonGenerator.writeArrayFieldStart("MBeans");
        for (ObjectName objectName : sortedObjectNames) {
            this.writeSingleMBean(objectName, jsonGenerator);
        }
        jsonGenerator.writeEndArray();
    }

    private void writeSingleMBean(ObjectName objectName, JsonGenerator jsonGenerator) throws Exception {
        jsonGenerator.writeStartObject();
        MBeanInfo mBeanInfo = this.server.getMBeanInfo(objectName);
        this.writeMBeanInfo(objectName, mBeanInfo, jsonGenerator);
        this.writeMBeanAttributes(objectName, mBeanInfo, jsonGenerator);
        jsonGenerator.writeEndObject();
    }

    private void writeMBeanInfo(ObjectName objectName, MBeanInfo mBeanInfo, JsonGenerator jasonGenerator) throws JsonGenerationException, IOException {
        jasonGenerator.writeObjectFieldStart("Info");
        jasonGenerator.writeStringField("ObjectName", objectName.toString());
        jasonGenerator.writeStringField("ClassName", mBeanInfo.getClassName());
        jasonGenerator.writeStringField("Description", mBeanInfo.getDescription());
        jasonGenerator.writeEndObject();
    }

    private void writeMBeanAttributes(ObjectName objectName, MBeanInfo mBeanInfo, JsonGenerator jasonGenerator) throws JsonGenerationException, IOException {
        jasonGenerator.writeArrayFieldStart("Attributes");
        for (MBeanAttributeInfo attributeInfo : mBeanInfo.getAttributes()) {
            jasonGenerator.writeStartObject();
            String attributeName = attributeInfo.getName();
            jasonGenerator.writeStringField("Name", attributeName);
            Object attributeValue = this.readAttributeValue(objectName, attributeName);
            this.writeAttributeValue(attributeValue, jasonGenerator);
            jasonGenerator.writeObjectFieldStart("MBeanAttributeInfo");
            jasonGenerator.writeStringField("Description", attributeInfo.getDescription());
            jasonGenerator.writeBooleanField("Readable", attributeInfo.isReadable());
            jasonGenerator.writeBooleanField("Writable", attributeInfo.isWritable());
            jasonGenerator.writeBooleanField("Is", attributeInfo.isIs());
            jasonGenerator.writeStringField("Type", attributeInfo.getType());
            jasonGenerator.writeEndObject();
            jasonGenerator.writeEndObject();
        }
        jasonGenerator.writeEndArray();
    }

    private Object readAttributeValue(ObjectName objectName, String attributeName) {
        Object attributeValue = null;
        try {
            attributeValue = this.server.getAttribute(objectName, attributeName);
        }
        catch (Exception ex) {
            attributeValue = ex.getMessage();
        }
        return attributeValue;
    }

    private void writeAttributeValue(Object attributeValue, JsonGenerator jasonGenerator) throws IOException, JsonGenerationException {
        this.writeAttributeValue(attributeValue, jasonGenerator, true);
    }

    private void writeAttributeValue(Object attributeValue, JsonGenerator jasonGenerator, boolean writeFieldName) throws IOException, JsonGenerationException {
        if (writeFieldName) {
            jasonGenerator.writeFieldName("Value");
        }
        if (attributeValue == null) {
            jasonGenerator.writeNull();
        } else if (attributeValue.getClass().isArray()) {
            this.writeArrayAttributeValue(attributeValue, jasonGenerator);
        } else if (attributeValue instanceof TabularData) {
            this.writeTabularAttributeValue((TabularData)attributeValue, jasonGenerator);
        } else if (attributeValue instanceof CompositeData) {
            this.writeCompositeAttributeValue((CompositeData)attributeValue, jasonGenerator);
        } else {
            jasonGenerator.writeString(attributeValue.toString());
        }
    }

    private void writeArrayAttributeValue(Object arrayValue, JsonGenerator jasonGenerator) throws IOException, JsonGenerationException {
        jasonGenerator.writeStartArray();
        int length = Array.getLength(arrayValue);
        for (int i = 0; i < length; ++i) {
            Object arrayElement = Array.get(arrayValue, i);
            this.writeAttributeValue(arrayElement, jasonGenerator, false);
        }
        jasonGenerator.writeEndArray();
    }

    private void writeCompositeAttributeValue(CompositeData compositeData, JsonGenerator jasonGenerator) throws JsonGenerationException, IOException {
        jasonGenerator.writeStartObject();
        CompositeType compositeType = compositeData.getCompositeType();
        jasonGenerator.writeStringField("TypeName", compositeType.getTypeName());
        jasonGenerator.writeFieldName("Values");
        this.writeCompositeData(compositeData, jasonGenerator);
        jasonGenerator.writeEndObject();
    }

    private void writeTabularAttributeValue(TabularData tabularData, JsonGenerator jasonGenerator) throws JsonGenerationException, IOException {
        jasonGenerator.writeStartObject();
        TabularType tabularType = tabularData.getTabularType();
        jasonGenerator.writeStringField("TypeName", tabularType.getTypeName());
        jasonGenerator.writeArrayFieldStart("Values");
        for (Object value : tabularData.values()) {
            this.writeCompositeData((CompositeData)value, jasonGenerator);
        }
        jasonGenerator.writeEndArray();
        jasonGenerator.writeEndObject();
    }

    private void writeCompositeData(CompositeData compositeData, JsonGenerator jasonGenerator) throws JsonGenerationException, IOException {
        jasonGenerator.writeStartObject();
        CompositeType compositeType = compositeData.getCompositeType();
        for (String key : compositeType.keySet()) {
            jasonGenerator.writeFieldName(key.toString());
            Object value = compositeData.get(key.toString());
            this.writeAttributeValue(value, jasonGenerator, false);
        }
        jasonGenerator.writeEndObject();
    }

    private void writeGeneratedJson(PrintWriter writer, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.flush();
        writer.println(jsonGenerator.getOutputTarget().toString());
    }
}

