/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

(function($) {
	var editorButtonTpl = "<button class='ui-state-default ui-corner-all opentype' type='button'>Editor</button>";
	var arrayTpl = "<form class='array'><p class='desc'></p><p class='type'></p><ol class='inputs' start='0'></ol><button class='ui-state-default ui-corner-all add' type='button'>Add</button> <input class='ui-state-default ui-corner-all' type='submit' value='Save' /></form>";
	var arrayItemTpl = "<li><input class='ui-state-default ui-corner-all inputText' name='dummy' /> <button class='ui-state-default ui-corner-all delete' type='button'>Delete</button></li>";
	var compositeTpl = "<form class='composite'><p class='desc'></p><ol class='inputs'></ol><input class='ui-state-default ui-corner-all' type='submit' value='Save' /></form>";
	var compositeItemTpl = "<li><label><span class='type'></span> <span class='name'></span> <input class='ui-state-default ui-corner-all inputText' /></label><p class='desc'></p></li>";
	
	var toJson = function(s, defaultValue) {
		try {
			return JSON.parse(s);
		} catch (e) {
			return defaultValue;
		}
	};
	
	var fromInputValue = function(s, type) {
		if (!s)
			return s;
		
		if (type["class"] == "javax.management.openmbean.SimpleType") {
			return s;
		}
		
		return JSON.parse(s);
	};
	
	var toInputValue = function(o, type) {
		if (type["class"] == "javax.management.openmbean.SimpleType") {
			return o;
		}
		
		return JSON.stringify(o);
	};
	
	var eachInput = function(form, callback) {
		var inputs = form.elements;
		for (var i = 0, ln = inputs.length; i < ln; i++) {
			callback(inputs[i]);
		}
	};
	
	var arrayConfig = {
		defaultValue: [],
		createForm: function(type, value) {
			var form = $(arrayTpl);
			var ol = form.find("ol");
			
			form.find("p.type").text(type.elementOpenType.className);
			form.find(".desc").text(type.description);
			
			for (var i = 0, ln = value.length; i < ln; i++) {
				$(arrayItemTpl).appendTo(ol).find("input")
					.opentype({
						type: type.elementOpenType
					})
					.val(toInputValue(value[i], type.elementOpenType));
			}
			
			form.find("button.add").click(function() {
				$(arrayItemTpl).appendTo(ol).find("input").opentype({
					type: type.elementOpenType
				});
			});
			
			form.find("button.delete").live("click", function() {
				$(this).parent("li").remove();
			});
			
			return form;
		},
		getResult: function(form) {
			var json = [];
			eachInput(form.get(0), function(input) {
				if (input.name) {
					var type = $(input).data("opentype").type;
					json.push(fromInputValue(input.value, type));
				}
			});
			
			return json;
		}
	};
	
	var compositeConfig = {
		defaultValue: {},
		createForm: function(type, value) {
			var form = $(compositeTpl);
			var ol = form.find("ol");
			form.find(".desc").text(type.description);
			
			for (var i = 0, ln = type.keys.length; i < ln; i++) {
				var key = type.keys[i];
				
				var item = $(compositeItemTpl).appendTo(ol);
				item.find("input")
					.attr("name", key.key)
					.attr("data-opentype", JSON.stringify(key.type))
					.opentype()
					.val(toInputValue(value[key.key], key.type));
				item.find("label span.name").text(key.key);
				item.find("label span.type").text(key.type.className);
				item.find(".desc").text(key.description);
			}
			
			return form;
		},
		getResult: function(form) {
			var json = {};
			eachInput(form.get(0), function(input) {
				if (input.name) {
					var type = $(input).data("opentype").type;
					json[input.name] = fromInputValue(input.value, type);
				}
			});
			
			return json;
		}
	};
	
	var tabularConfig = {
		defaultValue: [],
		createForm: function(type, value) {
			var form = $(arrayTpl);
			var ol = form.find("ol");
			
			form.find("p.type").text(type.rowType.className);
			form.find(".desc").text(type.description);
			
			for (var i = 0, ln = value.length; i < ln; i++) {
				$(arrayItemTpl).appendTo(ol).find("input")
					.opentype({
						type: type.rowType
					})
					.val(toInputValue(value[i], type.rowType));
			}
			
			form.find("button.add").click(function() {
				$(arrayItemTpl).appendTo(ol).find("input").opentype({
					type: type.rowType
				});
			});
			
			form.find("button.delete").live("click", function() {
				$(this).parent("li").remove();
			});
			
			return form;
		},
		getResult: function(form) {
			var json = [];
			eachInput(form.get(0), function(input) {
				if (input.name) {
					var type = $(input).data("opentype").type;
					json.push(fromInputValue(input.value, type));
				}
			});
			
			return json;
		}
	};
	
	var open = function(e) {
		var input = e.data;
		var type = input.data("opentype").type;
		
		if (type["class"] == "javax.management.openmbean.ArrayType") {
			var config = arrayConfig;
		} else if (type["class"] == "javax.management.openmbean.CompositeType") {
			var config = compositeConfig;
		} else if (type["class"] == "javax.management.openmbean.TabularType") {
			var config = tabularConfig;
		}
		
		var value = toJson(input.val(), config.defaultValue);
		var form = config.createForm(type, value);
		
		form.find("input[type=submit]").click(function(e) {
			e.preventDefault();
			
			var v = JSON.stringify(config.getResult(form));
			input.val(v);
			form.dialog("destroy");
			return false;
		});
		
		form.dialog({
			dialogClass: "opentype",
			modal: true,
			title: type.typeName,
			width: 600
		});
	};
	
	$.fn.opentype = function(config) {
		return this.each(function() {
			var $this = $(this),
				data = $this.data("opentype");
			
			if (data)
				return;
			
			var cfg = $.extend({}, config);
			if (!cfg.type) {
				var a = $this.attr("data-opentype");
				if (a) {
					cfg.type = JSON.parse(a);
				} else {
					return;
				}
			}
			
			$this.data("opentype", cfg);
			
			if (cfg.type["class"] == "javax.management.openmbean.SimpleType") {
				return;
			}
			
			$(editorButtonTpl).insertAfter($this).bind("click.opentype", $this, open);
		});
	}
})(jQuery);

$(function() {
	$("#content table.attributes, #content table.operations").tablesorter();
	
	$("#content .attributes td.editable").click(function(e) {
		var el = $(this);
		var form = el.find("form");
		var title = el.prev().text();
		
		var cloned = form.clone();

		var openType = el.attr("data-opentype");
		if (openType) {
			var input = cloned.find(".input input");
			input.opentype({
				type: JSON.parse(openType)
			});
		}
		
		cloned.submit(function(e) {
			e.preventDefault();
			
			var el = $(this);

			$.ajax({
				url: el.attr("action"),
				cache: false,
				type: el.attr("method"),
				data: el.serialize(),
				success: function(data, textStatus) {
					el.dialog("close");
					window.location.reload();
				}
			});

			return false;
		});
		
		cloned.dialog({
			dialogClass: "attribute",
			modal: true,
			title: title,
			width: 650
		});
	});

	$("#content .operations h4.editable").click(function(e) {
		var el = $(this);
		var dialog = el.nextAll(".dialog");
		var title = dialog.find("h4").text();
		
		var cloned = dialog.clone();
		cloned.find(".input input").opentype();
		cloned.data("success", false);
		cloned.children("form").submit(function(e) {
			e.preventDefault();
			
			var el = $(this);
			var output = el.parent().find(".output");
			
			var spinner = $("<div class='spinner'></div>").appendTo(el);

			$.ajax({
				url: el.attr("action"),
				cache: false,
				type: el.attr("method"),
				data: el.serialize(),
				success: function(data, textStatus) {
					spinner.remove();
					var parent = el.parent();
					
					if (!data) {
						data = "(Done)";
						output.text(data).slideDown();
					} else {
						output.html(data).slideDown(function() {
							var maxHeight = $(window).height() - 80;
							if (parent.height() > maxHeight) {
								parent.height(maxHeight);
								parent.dialog("option", "position", "center");
							}						
						});
					}
					parent.data("success", true);
				},
				error: function(xhr, textStatus, errorThrown) {
					spinner.remove();
					// Felix console will handle ajax error globally.
				}
			});

			return false;
		});

		cloned.dialog({
			dialogClass: "operation",
			modal: true,
			title: title,
			width: 700,
			close: function() {
				if (cloned.data("success")) {
					window.location.reload();
				}
			}
		});
	});
});
