/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.socialgraph.impl;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.resource.JcrResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertyMap
implements ValueMap {
    private static final Logger log = LoggerFactory.getLogger(AbstractPropertyMap.class);
    protected final String path;

    protected abstract Node getNode(boolean var1);

    protected AbstractPropertyMap(String path) {
        this.path = path;
    }

    public void clear() {
        throw new UnsupportedOperationException("Clearing a JCR backed value map is not supported, yet");
    }

    public Object put(String key, Object value) {
        if (key.indexOf(47) != -1) {
            throw new IllegalArgumentException("Invalid key: " + key);
        }
        if (value == null) {
            throw new NullPointerException("Value should not be null (key = " + key + ")");
        }
        Node node = this.getNode(true);
        Object oldValue = this.internalGet(node, key);
        this.internalSet(node, key, value);
        return oldValue;
    }

    public void putAll(Map<? extends String, ? extends Object> t) {
        if (t != null) {
            for (Map.Entry<? extends String, ? extends Object> entry : t.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public Object remove(Object key) {
        String sKey = key.toString();
        if (sKey.indexOf(47) != -1) {
            throw new IllegalArgumentException("Invalid key: " + sKey);
        }
        Node node = this.getNode(true);
        Object oldValue = this.internalGet(node, sKey);
        try {
            if (node.hasProperty(sKey)) {
                node.getProperty(sKey).remove();
            }
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        return oldValue;
    }

    public void reset() {
        throw new UnsupportedOperationException("Resetting a JCR backed value map is not supported, yet");
    }

    public <T> T get(String key, Class<T> type) {
        if (type == null) {
            return (T)this.get(key);
        }
        Node node = this.getNode(false);
        return node == null ? null : (T)this.internalGet(node, key, type);
    }

    public <T> T get(String key, T defaultValue) {
        if (defaultValue == null) {
            return (T)this.get(key);
        }
        Class<?> type = this.normalizeClass(defaultValue.getClass());
        Class<Object> value = this.get(key, (T)type);
        if (value == null) {
            value = defaultValue;
        }
        return (T)value;
    }

    public Object get(Object key) {
        Node node = this.getNode(false);
        return node == null ? null : this.internalGet(node, key.toString());
    }

    public boolean containsKey(Object key) {
        Node node = this.getNode(false);
        try {
            return node != null && node.hasProperty(key.toString());
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("containsValue on a JCR backed value map is not supported, yet");
    }

    public boolean isEmpty() {
        return this.getNode(false) == null;
    }

    public int size() {
        Node node = this.getNode(false);
        int cnt = 0;
        if (node != null) {
            try {
                PropertyIterator iter = node.getProperties();
                while (iter.hasNext()) {
                    iter.next();
                    ++cnt;
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return cnt;
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Node node = this.getNode(false);
        if (node != null) {
            try {
                PropertyIterator iter = node.getProperties();
                while (iter.hasNext()) {
                    Property p = iter.nextProperty();
                    map.put(p.getName(), JcrResourceUtil.toJavaObject((Property)p));
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return Collections.unmodifiableSet(map.entrySet());
    }

    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>();
        Node node = this.getNode(false);
        if (node != null) {
            try {
                PropertyIterator iter = node.getProperties();
                while (iter.hasNext()) {
                    Property p = iter.nextProperty();
                    set.add(p.getName());
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return Collections.unmodifiableSet(set);
    }

    public Collection<Object> values() {
        HashSet<Object> set = new HashSet<Object>();
        Node node = this.getNode(false);
        if (node != null) {
            try {
                PropertyIterator iter = node.getProperties();
                while (iter.hasNext()) {
                    Property p = iter.nextProperty();
                    set.add(JcrResourceUtil.toJavaObject((Property)p));
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return Collections.unmodifiableSet(set);
    }

    private Object internalGet(Node node, String key) {
        try {
            if (node.hasProperty(key)) {
                return JcrResourceUtil.toJavaObject((Property)node.getProperty(key));
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return null;
    }

    private <T> T internalGet(Node node, String key, Class<T> type) {
        try {
            if (node.hasProperty(key)) {
                return this.internalGet(node.getProperty(key), type);
            }
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        return null;
    }

    private <T> T internalGet(Property p, Class<T> type) {
        Object result = null;
        try {
            boolean array = type.isArray();
            if (p.isMultiple()) {
                Value[] values = p.getValues();
                if (array) {
                    result = this.convertToArray(p, values, type.getComponentType());
                } else if (values.length > 0) {
                    result = this.convertToType(p, values[0], type);
                }
            } else {
                Value value = p.getValue();
                result = array ? this.convertToArray(p, new Value[]{value}, type.getComponentType()) : (Object)this.convertToType(p, value, type);
            }
        }
        catch (ValueFormatException vfe) {
            log.info("converToType: Cannot convert value of " + p + " to " + type, (Throwable)vfe);
        }
        catch (RepositoryException re) {
            log.info("converToType: Cannot get value of " + p, (Throwable)re);
        }
        return (T)result;
    }

    private void internalSet(Node node, String key, Object value) {
        try {
            Session session = node.getSession();
            if (value.getClass().isArray()) {
                Object[] values = (Object[])value;
                Value[] jcrValues = new Value[values.length];
                for (int i = 0; i < values.length; ++i) {
                    jcrValues[i] = JcrResourceUtil.createValue((Object)values[i], (Session)session);
                    if (jcrValues[i] != null) continue;
                    throw new IllegalArgumentException("Value can't be stored in the repository: " + values[i]);
                }
                node.setProperty(key, jcrValues);
            } else {
                Value jcrValue = JcrResourceUtil.createValue((Object)value, (Session)session);
                if (jcrValue == null) {
                    throw new IllegalArgumentException("Value can't be stored in the repository: " + value);
                }
                node.setProperty(key, jcrValue);
            }
        }
        catch (RepositoryException e) {
            throw new IllegalArgumentException("Unable to store value", e);
        }
    }

    private <T> T[] convertToArray(Property p, Value[] jcrValues, Class<T> type) throws ValueFormatException, RepositoryException {
        ArrayList<T> values = new ArrayList<T>();
        for (Value jcrValue : jcrValues) {
            T value = this.convertToType(p, jcrValue, type);
            if (value == null) continue;
            values.add(value);
        }
        Object[] result = (Object[])Array.newInstance(type, values.size());
        return values.toArray(result);
    }

    private <T> T convertToType(Property p, Value jcrValue, Class<T> type) throws ValueFormatException, RepositoryException {
        if (String.class == type) {
            return (T)jcrValue.getString();
        }
        if (Byte.class == type) {
            return (T)Byte.valueOf((byte)jcrValue.getLong());
        }
        if (Short.class == type) {
            return (T)Short.valueOf((short)jcrValue.getLong());
        }
        if (Integer.class == type) {
            return (T)Integer.valueOf((int)jcrValue.getLong());
        }
        if (Long.class == type) {
            return (T)Long.valueOf(jcrValue.getLong());
        }
        if (Float.class == type) {
            return (T)Float.valueOf((float)jcrValue.getDouble());
        }
        if (Double.class == type) {
            return (T)Double.valueOf(jcrValue.getDouble());
        }
        if (BigDecimal.class == type) {
            return (T)jcrValue.getDecimal();
        }
        if (Boolean.class == type) {
            return (T)Boolean.valueOf(jcrValue.getBoolean());
        }
        if (Date.class == type) {
            return (T)jcrValue.getDate().getTime();
        }
        if (Calendar.class == type) {
            return (T)jcrValue.getDate();
        }
        if (Value.class == type) {
            return (T)jcrValue;
        }
        if (Property.class == type) {
            return (T)p;
        }
        return null;
    }

    private Class<?> normalizeClass(Class<?> type) {
        if (Calendar.class.isAssignableFrom(type)) {
            type = Calendar.class;
        } else if (Date.class.isAssignableFrom(type)) {
            type = Date.class;
        } else if (Value.class.isAssignableFrom(type)) {
            type = Value.class;
        } else if (Property.class.isAssignableFrom(type)) {
            type = Property.class;
        }
        return type;
    }
}

