/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.socialgraph.impl;

import com.adobe.granite.socialgraph.Direction;
import com.adobe.granite.socialgraph.GraphNode;
import com.adobe.granite.socialgraph.Relationship;
import com.adobe.granite.socialgraph.SocialGraphException;
import com.adobe.granite.socialgraph.impl.AbstractPropertyMap;
import com.adobe.granite.socialgraph.impl.JcrRelationship;
import com.adobe.granite.socialgraph.impl.JcrSocialGraph;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrGraphNode
extends AbstractPropertyMap
implements GraphNode {
    private static final Logger log = LoggerFactory.getLogger(JcrGraphNode.class);
    public static String SOCIAL_NODE_NAME = "social";
    public static String RELATIONSHIPS_NODE_NAME = "relationships";
    public static String SOCIAL_NODE_TYPE = "sling:Folder";
    public static String RELATIONSHIPS_NODE_TYPE = "sling:Folder";
    public static String RELATIONSHIP_NODE_TYPE = "nt:unstructured";
    public static String ID_PROPERTY_NAME = "id";
    private final JcrSocialGraph graph;
    private final String authId;
    private final boolean isGroupNode;

    public JcrGraphNode(JcrSocialGraph graph, String path, String authId, boolean isGroupNode) {
        super(path);
        this.graph = graph;
        this.authId = authId;
        this.isGroupNode = isGroupNode;
    }

    @Override
    public String getId() {
        return this.authId == null ? this.path : this.authId;
    }

    @Override
    public Resource getResource() {
        return this.graph.getResource(this.path);
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    public boolean isGroupNode() {
        return this.isGroupNode;
    }

    @Override
    protected Node getNode(boolean create) {
        if (this.authId == null) {
            log.debug("GraphNodes on non users not supported");
            return null;
        }
        Session session = this.graph.getSession();
        try {
            if (!session.nodeExists(this.path)) {
                return null;
            }
            Node node = session.getNode(this.path);
            Node ret = null;
            if (node.hasNode(SOCIAL_NODE_NAME)) {
                ret = node.getNode(SOCIAL_NODE_NAME);
            } else if (create) {
                try {
                    ret = node.addNode(SOCIAL_NODE_NAME, SOCIAL_NODE_TYPE);
                }
                catch (RepositoryException e) {
                    String msg = String.format("Error while creating social node %s/%s", this.path, SOCIAL_NODE_NAME);
                    log.error(msg);
                    throw new SocialGraphException(msg, e);
                }
            }
            return ret;
        }
        catch (RepositoryException e) {
            log.warn("Unable to read social node", (Throwable)e);
            return null;
        }
    }

    protected Node getRelationshipsNode(boolean create) {
        Node socialNode = this.getNode(create);
        if (socialNode == null) {
            return null;
        }
        try {
            if (socialNode.hasNode(RELATIONSHIPS_NODE_NAME)) {
                return socialNode.getNode(RELATIONSHIPS_NODE_NAME);
            }
            if (create) {
                try {
                    return socialNode.addNode(RELATIONSHIPS_NODE_NAME, RELATIONSHIPS_NODE_TYPE);
                }
                catch (RepositoryException e) {
                    String msg = String.format("Error while creating relationships node %s/%s/%s", this.path, SOCIAL_NODE_NAME, RELATIONSHIPS_NODE_NAME);
                    log.error(msg);
                    throw new SocialGraphException(msg, e);
                }
            }
        }
        catch (RepositoryException e) {
            log.warn("Unable to read relationships node", (Throwable)e);
        }
        return null;
    }

    @Override
    public void delete() {
        Node node = this.getNode(false);
        if (node != null) {
            try {
                node.remove();
            }
            catch (RepositoryException e) {
                log.warn("Error while removing graph node", (Throwable)e);
            }
        }
    }

    @Override
    public Iterable<Relationship> getRelationships(Direction dir, String ... types) {
        HashMap<String, Relationship> relations = new HashMap<String, Relationship>();
        try {
            switch (dir) {
                case BOTH: {
                    this.fillOutgoingRelationships(relations, types);
                    this.fillIncomingRelationships(relations, types);
                    if (this.authId == null) break;
                    this.graph.fillOutgoingVirtualRelationships(this.authId, relations, types);
                    this.graph.fillIncomingVirtualRelationships(this.authId, relations, types);
                    break;
                }
                case INCOMING: {
                    this.fillIncomingRelationships(relations, types);
                    if (this.authId == null) break;
                    this.graph.fillIncomingVirtualRelationships(this.authId, relations, types);
                    break;
                }
                case OUTGOING: {
                    this.fillOutgoingRelationships(relations, types);
                    if (this.authId == null) break;
                    this.graph.fillOutgoingVirtualRelationships(this.authId, relations, types);
                }
            }
        }
        catch (RepositoryException e) {
            log.error("Error while reading relationships", (Throwable)e);
        }
        return relations.values();
    }

    private void fillIncomingRelationships(Map<String, Relationship> relations, String[] types) throws RepositoryException {
        String escapedId = this.getId().replaceAll("'", "''");
        if (types == null || types.length == 0) {
            StringBuilder queryString = new StringBuilder("/jcr:root/home//").append(SOCIAL_NODE_NAME).append('/').append(RELATIONSHIPS_NODE_NAME).append("//*[id='").append(escapedId).append("']");
            Query q = this.graph.getSession().getWorkspace().getQueryManager().createQuery(queryString.toString(), "xpath");
            QueryResult res = q.execute();
            NodeIterator iter = res.getNodes();
            while (iter.hasNext()) {
                Node relNode = iter.nextNode();
                String relPath = relNode.getPath();
                String type = Text.getName((String)Text.getRelativeParent((String)relPath, (int)1));
                String userId = Text.getName((String)Text.getRelativeParent((String)relPath, (int)4));
                JcrRelationship rel = new JcrRelationship(this.graph, relPath, type, userId, this.getId());
                relations.put(rel.signature(), rel);
            }
        } else {
            for (String type : types) {
                StringBuilder queryString = new StringBuilder("/jcr:root/home//").append(SOCIAL_NODE_NAME).append('/').append(RELATIONSHIPS_NODE_NAME).append('/').append(ISO9075.encode((String)type)).append("//*[id='").append(escapedId).append("']");
                Query q = this.graph.getSession().getWorkspace().getQueryManager().createQuery(queryString.toString(), "xpath");
                QueryResult res = q.execute();
                NodeIterator iter = res.getNodes();
                while (iter.hasNext()) {
                    Node relNode = iter.nextNode();
                    String relPath = relNode.getPath();
                    String userId = Text.getName((String)Text.getRelativeParent((String)relPath, (int)4));
                    JcrRelationship rel = new JcrRelationship(this.graph, relPath, type, userId, this.getId());
                    relations.put(rel.signature(), rel);
                }
            }
        }
    }

    private void fillOutgoingRelationships(Map<String, Relationship> relations, String ... types) throws RepositoryException {
        Node rNode = this.getRelationshipsNode(false);
        if (rNode == null) {
            return;
        }
        if (types == null || types.length == 0) {
            NodeIterator iter = rNode.getNodes();
            while (iter.hasNext()) {
                Node typeNode = iter.nextNode();
                String type = typeNode.getName();
                this.fillRelationships(relations, typeNode, type);
            }
        } else {
            for (String type : types) {
                if (!rNode.hasNode(type)) continue;
                Node typeNode = rNode.getNode(type);
                this.fillRelationships(relations, typeNode, type);
            }
        }
    }

    private void fillRelationships(Map<String, Relationship> relations, Node typeNode, String type) throws RepositoryException {
        NodeIterator iter = typeNode.getNodes();
        while (iter.hasNext()) {
            Node relNode = iter.nextNode();
            try {
                String otherId = relNode.getProperty("id").getString();
                JcrRelationship rel = new JcrRelationship(this.graph, relNode.getPath(), type, this.authId, otherId);
                relations.put(rel.signature(), rel);
            }
            catch (RepositoryException e) {
                log.warn("Relationship node has no 'id' property {}", (Object)relNode.getPath());
            }
        }
    }

    @Override
    public Relationship getRelationship(Direction dir, GraphNode node, String type) {
        if (type == null || type.length() == 0) {
            throw new IllegalArgumentException("Type must not be null or empty.");
        }
        switch (dir) {
            case BOTH: {
                throw new IllegalArgumentException("Only incoming or outgoing allowed.");
            }
            case INCOMING: {
                return node.getRelationship(Direction.OUTGOING, this, type);
            }
            case OUTGOING: {
                HashMap<String, Relationship> relations;
                Relationship relationship = null;
                if (node instanceof JcrGraphNode && ((JcrGraphNode)node).isGroupNode()) {
                    try {
                        relations = new HashMap();
                        this.graph.fillIncomingVirtualRelationships(node.getId(), relations, type);
                        for (Relationship r : relations.values()) {
                            if (!this.equals(r.getStartNode())) continue;
                            relationship = r;
                        }
                    }
                    catch (RepositoryException e) {
                        log.error("Error while retrieving relationships", (Throwable)e);
                    }
                } else if (this.isGroupNode) {
                    try {
                        relations = new HashMap<String, Relationship>();
                        this.graph.fillOutgoingVirtualRelationships(this.authId, relations, type);
                        for (Relationship r : relations.values()) {
                            if (!r.getEndNode().equals(node)) continue;
                            relationship = r;
                        }
                    }
                    catch (RepositoryException e) {
                        log.error("Error while retrieving relationships", (Throwable)e);
                    }
                }
                String typePath = this.path + '/' + SOCIAL_NODE_NAME + '/' + RELATIONSHIPS_NODE_NAME + '/' + type;
                try {
                    if (this.graph.getSession().nodeExists(typePath)) {
                        String otherId = node.getId();
                        Node typeNode = this.graph.getSession().getNode(typePath);
                        NodeIterator iter = typeNode.getNodes();
                        while (iter.hasNext()) {
                            String id;
                            Node relNode = iter.nextNode();
                            if (!relNode.hasProperty(ID_PROPERTY_NAME) || !(id = relNode.getProperty(ID_PROPERTY_NAME).getString()).equals(otherId)) continue;
                            return new JcrRelationship(this.graph, relNode.getPath(), type, this.authId, otherId);
                        }
                    }
                }
                catch (RepositoryException e) {
                    log.warn("Error while reading relationship node", (Throwable)e);
                }
                return relationship;
            }
        }
        return null;
    }

    @Override
    public Relationship createRelationshipTo(GraphNode other, String type) {
        if (other == null) {
            throw new IllegalArgumentException("Unable to creation relationship. 'other' must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Unable to creation relationship. 'type' must not be null.");
        }
        if (this.equals(other)) {
            throw new IllegalArgumentException("Unable to creation relationship. self relationships not allowed.");
        }
        Relationship r = this.getRelationship(Direction.OUTGOING, other, type);
        if (r != null && !r.isVirtual()) {
            String msg = String.format("Unable to create relationship of type '%s' from '%s' to '%s'. Already exists.", type, this.authId, other.getId());
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        try {
            Node relationshipsNode = this.getRelationshipsNode(true);
            Node relationshipTypesNode = relationshipsNode.hasNode(type) ? relationshipsNode.getNode(type) : relationshipsNode.addNode(type, RELATIONSHIPS_NODE_TYPE);
            String otherId = other.getId();
            NodeIterator iter = relationshipTypesNode.getNodes();
            while (iter.hasNext()) {
                String id;
                Node relNode = iter.nextNode();
                if (!relNode.hasProperty(ID_PROPERTY_NAME) || !(id = relNode.getProperty(ID_PROPERTY_NAME).getString()).equals(otherId)) continue;
                String msg = String.format("Unable to create relationship of type '%s' from '%s' to '%s'. Already exists.", type, this.authId, otherId);
                log.error(msg);
                throw new IllegalArgumentException(msg);
            }
            String nameHint = Text.getName((String)otherId);
            int cnt = 0;
            while (relationshipTypesNode.hasNode(nameHint)) {
                nameHint = Text.getName((String)otherId) + cnt++;
            }
            Node rNode = relationshipTypesNode.addNode(nameHint, RELATIONSHIP_NODE_TYPE);
            JcrRelationship rel = new JcrRelationship(this.graph, rNode.getPath(), type, this.authId, otherId);
            rel.put("jcr:created", (Object)Calendar.getInstance());
            rel.put("jcr:createdBy", (Object)this.graph.getSession().getUserID());
            rel.put(ID_PROPERTY_NAME, (Object)otherId);
            return rel;
        }
        catch (RepositoryException e) {
            log.error("Error while creating relationship", (Throwable)e);
            throw new SocialGraphException("Error while creation relationship", e);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GraphNode)) {
            return false;
        }
        GraphNode that = (GraphNode)o;
        return this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JcrGraphNode");
        sb.append("{authId='").append(this.authId).append('\'');
        sb.append(", path='").append(this.path).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

