/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.socialgraph.impl;

import com.adobe.granite.socialgraph.Direction;
import com.adobe.granite.socialgraph.GraphNode;
import com.adobe.granite.socialgraph.Relationship;
import com.adobe.granite.socialgraph.impl.AbstractPropertyMap;
import com.adobe.granite.socialgraph.impl.JcrSocialGraph;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrRelationship
extends AbstractPropertyMap
implements Relationship {
    private static final Logger log = LoggerFactory.getLogger(JcrRelationship.class);
    private final JcrSocialGraph graph;
    private final String startId;
    private final String endId;
    private final String type;
    private final String signature;

    public JcrRelationship(JcrSocialGraph graph, String path, String type, String startId, String endId) {
        super(path);
        this.graph = graph;
        this.startId = startId;
        this.endId = endId;
        this.type = type;
        this.signature = Text.escape((String)startId) + ":" + Text.escape((String)type) + ":" + Text.escape((String)endId);
    }

    protected Node getNode(boolean create) {
        try {
            Session s = this.graph.getSession();
            if (s.nodeExists(this.path)) {
                return s.getNode(this.path);
            }
            if (create) {
                throw new IllegalArgumentException("relationship nodes must exist.");
            }
        }
        catch (RepositoryException e) {
            log.warn("error while reading relationship node", (Throwable)e);
        }
        return null;
    }

    public void delete() {
        try {
            Session s = this.graph.getSession();
            if (s.nodeExists(this.path)) {
                s.getNode(this.path).remove();
            }
        }
        catch (RepositoryException e) {
            log.warn("error while deleting relationship node", (Throwable)e);
        }
    }

    public String signature() {
        return this.signature;
    }

    public boolean isVirtual() {
        return false;
    }

    public GraphNode getStartNode() {
        return this.graph.getNode(this.startId);
    }

    public GraphNode getEndNode() {
        return this.graph.getNode(this.endId);
    }

    public GraphNode getOtherNode(GraphNode node) {
        String id = node.getId();
        if (id.equals(this.startId)) {
            return this.getEndNode();
        }
        if (id.equals(this.endId)) {
            return this.getStartNode();
        }
        throw new IllegalArgumentException("Neither start- or end node given.");
    }

    public boolean isBidirectional() {
        GraphNode start = this.getStartNode();
        GraphNode end = this.getEndNode();
        return end != null && start != null && end.getRelationship(Direction.OUTGOING, start, this.type) != null;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JcrRelationship");
        sb.append("{path='").append(this.path).append('\'');
        sb.append(", startId='").append(this.startId).append('\'');
        sb.append(", endId='").append(this.endId).append('\'');
        sb.append(", type=").append(this.type);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Relationship)) {
            return false;
        }
        Relationship that = (Relationship)o;
        return this.signature.equals(that.signature());
    }

    public int hashCode() {
        return this.signature.hashCode();
    }
}

