/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.socialgraph.impl;

import com.adobe.granite.socialgraph.GraphNode;
import com.adobe.granite.socialgraph.Relationship;
import com.adobe.granite.socialgraph.SocialGraph;
import com.adobe.granite.socialgraph.SocialGraphException;
import com.adobe.granite.socialgraph.impl.JcrGraphNode;
import com.adobe.granite.socialgraph.impl.SocialGraphConfig;
import com.adobe.granite.socialgraph.impl.VirtualRelationship;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.ArrayUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrSocialGraph
implements SocialGraph {
    private static final Logger log = LoggerFactory.getLogger(JcrSocialGraph.class);
    private final SlingRepository repository;
    private final ResourceResolver resolver;
    private final Session session;
    private final SocialGraphConfig config;

    public JcrSocialGraph(SlingRepository repo, ResourceResolver resolver, SocialGraphConfig config) throws RepositoryException {
        this.repository = repo;
        this.resolver = resolver;
        this.config = config;
        this.session = (Session)resolver.adaptTo(Session.class);
    }

    @Override
    public GraphNode getNode(String id) {
        if (id.startsWith("/")) {
            return new JcrGraphNode(this, id, null, false);
        }
        Session adminSession = null;
        try {
            adminSession = this.repository.loginAdministrative(null);
            UserManager adminUserManager = ((JackrabbitSession)adminSession).getUserManager();
            Authorizable a = adminUserManager.getAuthorizable(id);
            if (a != null) {
                JcrGraphNode jcrGraphNode = new JcrGraphNode(this, a.getPath(), id, a.isGroup());
                return jcrGraphNode;
            }
            log.debug("Unable to get graph node. ID '{}' refers neither to a user nor a group.", (Object)id);
            GraphNode graphNode = null;
            return graphNode;
        }
        catch (RepositoryException e) {
            log.error("Error while reading authorizable " + id, (Throwable)e);
            throw new SocialGraphException("Error while reading authorizable", e);
        }
        finally {
            if (adminSession != null) {
                adminSession.logout();
            }
        }
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public void save() {
        try {
            this.session.save();
        }
        catch (RepositoryException e) {
            log.error("Error while saving changes", (Throwable)e);
            throw new SocialGraphException("Error while saving changes", e);
        }
    }

    @Override
    public void refresh(boolean keepChanges) {
        try {
            this.session.refresh(keepChanges);
        }
        catch (RepositoryException e) {
            log.error("Error while refresh changes", (Throwable)e);
            throw new SocialGraphException("Error while refresh changes", e);
        }
    }

    protected Resource getResource(String path) {
        return this.resolver.getResource(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillOutgoingVirtualRelationships(String id, Map<String, Relationship> relations, String ... types) throws RepositoryException {
        Session adminSession = null;
        try {
            adminSession = this.repository.loginAdministrative(null);
            Authorizable a = ((JackrabbitSession)adminSession).getUserManager().getAuthorizable(id);
            if (a instanceof Group) {
                this.fillOutgoingRelationships((Group)a, relations, types);
            } else if (a instanceof User) {
                this.fillOutgoingRelationships((User)a, relations, types);
            }
        }
        catch (RepositoryException e) {
            log.error("Error while creating virtual relationships", (Throwable)e);
        }
        finally {
            if (adminSession != null) {
                adminSession.logout();
            }
        }
    }

    private void fillOutgoingRelationships(Group grp, Map<String, Relationship> relations, String[] types) throws RepositoryException {
        if (types != null && types.length > 0 && ArrayUtils.indexOf((Object[])types, (Object)this.config.getGroupOutgoingRelationship()) < 0) {
            return;
        }
        if (this.config.getOutgoingExcludedGroups().contains(grp.getID())) {
            return;
        }
        Iterator iter = grp.getMembers();
        while (iter.hasNext()) {
            Authorizable a = (Authorizable)iter.next();
            if (!(a instanceof User)) continue;
            VirtualRelationship rel = new VirtualRelationship(this, grp.getID(), a.getID(), this.config.getGroupOutgoingRelationship());
            relations.put(rel.signature(), rel);
        }
    }

    private void fillOutgoingRelationships(User user, Map<String, Relationship> relations, String[] types) throws RepositoryException {
        if (types != null && types.length > 0 && ArrayUtils.indexOf((Object[])types, (Object)this.config.getGroupIncomingRelationship()) < 0) {
            return;
        }
        Iterator iter = user.memberOf();
        while (iter.hasNext()) {
            Group grp = (Group)iter.next();
            if (this.config.getIncomingExcludedGroups().contains(grp.getID())) continue;
            VirtualRelationship rel = new VirtualRelationship(this, user.getID(), grp.getID(), this.config.getGroupIncomingRelationship());
            relations.put(rel.signature(), rel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillIncomingVirtualRelationships(String id, Map<String, Relationship> relations, String ... types) throws RepositoryException {
        Session adminSession = null;
        try {
            adminSession = this.repository.loginAdministrative(null);
            Authorizable a = ((JackrabbitSession)adminSession).getUserManager().getAuthorizable(id);
            if (a instanceof Group) {
                this.fillIncomingRelationships((Group)a, relations, types);
            } else if (a instanceof User) {
                this.fillIncomingRelationships((User)a, relations, types);
            }
        }
        catch (RepositoryException e) {
            log.error("Error while creating virtual relationships", (Throwable)e);
        }
        finally {
            if (adminSession != null) {
                adminSession.logout();
            }
        }
    }

    private void fillIncomingRelationships(Group grp, Map<String, Relationship> relations, String[] types) throws RepositoryException {
        if (types != null && types.length > 0 && ArrayUtils.indexOf((Object[])types, (Object)this.config.getGroupIncomingRelationship()) < 0) {
            return;
        }
        if (this.config.getIncomingExcludedGroups().contains(grp.getID())) {
            return;
        }
        Iterator iter = grp.getMembers();
        while (iter.hasNext()) {
            Authorizable a = (Authorizable)iter.next();
            if (!(a instanceof User)) continue;
            VirtualRelationship rel = new VirtualRelationship(this, a.getID(), grp.getID(), this.config.getGroupIncomingRelationship());
            relations.put(rel.signature(), rel);
        }
    }

    private void fillIncomingRelationships(User user, Map<String, Relationship> relations, String[] types) throws RepositoryException {
        if (types != null && types.length > 0 && ArrayUtils.indexOf((Object[])types, (Object)this.config.getGroupOutgoingRelationship()) < 0) {
            return;
        }
        Iterator iter = user.memberOf();
        while (iter.hasNext()) {
            Group grp = (Group)iter.next();
            if (this.config.getOutgoingExcludedGroups().contains(grp.getID())) continue;
            VirtualRelationship rel = new VirtualRelationship(this, grp.getID(), user.getID(), this.config.getGroupOutgoingRelationship());
            relations.put(rel.signature(), rel);
        }
    }
}

