/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.socialgraph.impl;

import com.adobe.granite.socialgraph.SocialGraph;
import com.adobe.granite.socialgraph.impl.SocialGraphFactory;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false)
@Property(name="service.description", value={"Social Graph Adapter"})
@Service(value={AdapterFactory.class})
public class SocialGraphAdapterFactory
implements AdapterFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Class<ResourceResolver> RESOURCE_RESOLVER_CLASS = ResourceResolver.class;
    private static final Class<SocialGraph> SOCIAL_GRAPH_CLASS = SocialGraph.class;
    @Property(name="adapters")
    public static final String[] ADAPTER_CLASSES = new String[]{SOCIAL_GRAPH_CLASS.getName()};
    @Property(name="adaptables")
    public static final String[] ADAPTABLE_CLASSES = new String[]{RESOURCE_RESOLVER_CLASS.getName()};
    @Reference
    private SocialGraphFactory factory = null;

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        if (adaptable instanceof ResourceResolver) {
            return this.getAdapter((ResourceResolver)adaptable, type);
        }
        this.logger.warn("Unable to handle adaptable {}", (Object)adaptable.getClass().getName());
        return null;
    }

    private <AdapterType> AdapterType getAdapter(ResourceResolver resolver, Class<AdapterType> type) {
        if (type == SOCIAL_GRAPH_CLASS) {
            try {
                return (AdapterType)this.factory.createSocialGraph(resolver);
            }
            catch (Exception e) {
                this.logger.error("Error while adapting to SocialGraph", (Throwable)e);
            }
        }
        this.logger.debug("Unable to adapt resource to type {}", (Object)type.getName());
        return null;
    }

    protected void bindFactory(SocialGraphFactory socialGraphFactory) {
        this.factory = socialGraphFactory;
    }

    protected void unbindFactory(SocialGraphFactory socialGraphFactory) {
        if (this.factory == socialGraphFactory) {
            this.factory = null;
        }
    }
}

