/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.socialgraph.impl;

import com.adobe.granite.socialgraph.SocialGraph;
import com.adobe.granite.socialgraph.SocialGraphException;
import com.adobe.granite.socialgraph.impl.JcrSocialGraph;
import com.adobe.granite.socialgraph.impl.SocialGraphConfig;
import com.adobe.granite.socialgraph.impl.SocialGraphFactory;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, label="Adobe Granite Social Graph Factory", description="Factory service that configures and creates the social graph bindings.")
@Service(value={SocialGraphFactory.class})
public class SocialGraphFactoryImpl
implements SocialGraphFactory {
    @Property(value={"following"}, label="GroupToMember RT", description="Defines the relationship type between a group and his group member.")
    static final String GROUP_2_MEMBER_RS_OUTGOING = "group2member.relationship.outgoing";
    @Property(value={}, label="Excluded GroupToMember", cardinality=0x7FFFFFFF, description="Defines the groups that do not create relationships to their group members.")
    static final String GROUP_2_MEMBER_EX_OUTGOING = "group2member.excluded.outgoing";
    @Property(value={"member"}, label="GroupFromMember RT", description="Defines the relationship type between a group member and his group.")
    static final String GROUP_2_MEMBER_RS_INCOMING = "group2member.relationship.incoming";
    @Property(value={"contributor", "content-authors"}, label="Excluded MemberToGroup", cardinality=0x7FFFFFFF, description="Defines the groups that do not create relationships from their group members.")
    static final String GROUP_2_MEMBER_EX_INCOMING = "group2member.excluded.incoming";
    @Reference
    private SlingRepository repository = null;
    private SocialGraphConfig config;

    @Activate
    private void activate(Map<String, Object> props) {
        this.config = new SocialGraphConfig();
        this.config.setGroupOutgoingRelationship(OsgiUtil.toString((Object)props.get(GROUP_2_MEMBER_RS_OUTGOING), (String)"following"));
        this.config.setOutgoingExcludedGroups(OsgiUtil.toStringArray((Object)props.get(GROUP_2_MEMBER_EX_OUTGOING)));
        this.config.setGroupIncomingRelationship(OsgiUtil.toString((Object)props.get(GROUP_2_MEMBER_RS_INCOMING), (String)"member"));
        this.config.setIncomingExcludedGroups(OsgiUtil.toStringArray((Object)props.get(GROUP_2_MEMBER_EX_INCOMING)));
    }

    @Override
    public SocialGraph createSocialGraph(ResourceResolver resolver) {
        try {
            return new JcrSocialGraph(this.repository, resolver, this.config);
        }
        catch (RepositoryException e) {
            throw new SocialGraphException("Unable to create social graph", e);
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

