/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.socialgraph.impl;

import com.adobe.granite.socialgraph.GraphNode;
import com.adobe.granite.socialgraph.Relationship;
import com.adobe.granite.socialgraph.impl.JcrSocialGraph;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualRelationship
implements Relationship {
    private final JcrSocialGraph graph;
    private final String startId;
    private final String endId;
    private final String type;
    private final String signature;
    private final ValueMap properties = new ValueMapDecorator(new HashMap());

    public VirtualRelationship(JcrSocialGraph graph, String startId, String endId, String type) {
        this.graph = graph;
        this.startId = startId;
        this.endId = endId;
        this.type = type;
        this.signature = Text.escape((String)startId) + ":" + Text.escape((String)type) + ":" + Text.escape((String)endId);
    }

    @Override
    public GraphNode getStartNode() {
        return this.graph.getNode(this.startId);
    }

    @Override
    public GraphNode getEndNode() {
        return this.graph.getNode(this.endId);
    }

    @Override
    public GraphNode getOtherNode(GraphNode node) {
        String id = node.getId();
        if (id.equals(this.startId)) {
            return this.getEndNode();
        }
        if (id.equals(this.endId)) {
            return this.getStartNode();
        }
        throw new IllegalArgumentException("Neither start- or end node given.");
    }

    @Override
    public boolean isBidirectional() {
        return true;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("Deleting virtual relationships is not supported.");
    }

    @Override
    public String signature() {
        return this.signature;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Relationship)) {
            return false;
        }
        Relationship that = (Relationship)o;
        return this.signature.equals(that.signature());
    }

    @Override
    public int hashCode() {
        return this.signature.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("VirtualRelationship");
        sb.append("{startId='").append(this.startId).append('\'');
        sb.append(", endId='").append(this.endId).append('\'');
        sb.append(", type='").append(this.type).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Override
    public <T> T get(String s, Class<T> tClass) {
        return (T)this.properties.get(s, tClass);
    }

    @Override
    public <T> T get(String s, T t) {
        return (T)this.properties.get(s, t);
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.properties.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.properties.containsValue(o);
    }

    @Override
    public Object get(Object o) {
        return this.properties.get(o);
    }

    @Override
    public Object put(String s, Object o) {
        return this.properties.put((Object)s, o);
    }

    @Override
    public Object remove(Object o) {
        return this.properties.remove(o);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        this.properties.putAll(map);
    }

    @Override
    public void clear() {
        this.properties.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.properties.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.properties.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.properties.entrySet();
    }
}

