/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.socialgraph.impl.rest;

import com.adobe.granite.socialgraph.Direction;
import com.adobe.granite.socialgraph.GraphNode;
import com.adobe.granite.socialgraph.Relationship;
import com.adobe.granite.socialgraph.SocialGraph;
import com.adobe.granite.socialgraph.impl.rest.RequestInfo;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(DeleteServlet.class);

    protected void doDelete(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        SocialGraph graph = (SocialGraph)request.getResourceResolver().adaptTo(SocialGraph.class);
        if (graph == null) {
            response.sendError(500, "Social graph not available.");
            return;
        }
        RequestInfo info = new RequestInfo(request);
        if (info.getId() == null) {
            response.sendError(404);
            return;
        }
        GraphNode node = graph.getNode(info.getId());
        if (node == null) {
            log.warn("No social graph node for user {}", (Object)info.getId());
            response.sendError(404);
            return;
        }
        if (info.getListType() == null) {
            node.delete();
            graph.save();
            response.setStatus(200);
            return;
        }
        if (info.getOtherId() == null) {
            log.warn("No social relationship addressed");
            response.sendError(404);
            return;
        }
        if (!"relationships".equals(info.getListType())) {
            log.warn("Only 'relationships' collection supported", (Object)info.getListType());
            response.sendError(404);
            return;
        }
        GraphNode other = graph.getNode(info.getOtherId());
        if (other == null) {
            log.warn("No social graph node for user {}", (Object)info.getOtherId());
            response.sendError(404);
            return;
        }
        Relationship rel = node.getRelationship(Direction.OUTGOING, other, info.getRelationshipType());
        if (rel == null) {
            response.sendError(404);
        } else {
            rel.delete();
            graph.save();
            response.setStatus(200);
        }
    }
}

