/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.socialgraph.impl.rest;

import com.adobe.granite.socialgraph.Direction;
import com.adobe.granite.socialgraph.GraphNode;
import com.adobe.granite.socialgraph.Relationship;
import com.adobe.granite.socialgraph.SocialGraph;
import com.adobe.granite.socialgraph.SocialGraphException;
import com.adobe.granite.socialgraph.impl.rest.RequestInfo;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(PostServlet.class);

    protected void doPut(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        SocialGraph graph = (SocialGraph)request.getResourceResolver().adaptTo(SocialGraph.class);
        if (graph == null) {
            response.sendError(500, "Social graph not available.");
            return;
        }
        RequestInfo info = new RequestInfo(request);
        if (info.getId() == null) {
            response.sendError(404);
            return;
        }
        GraphNode node = graph.getNode(info.getId());
        if (node == null) {
            log.warn("No social graph node for user {}", (Object)info.getId());
            response.sendError(404);
            return;
        }
        if (info.getListType() == null) {
            this.updateProperties(info, node);
            graph.save();
            response.setStatus(200);
            return;
        }
        if (info.getOtherId() == null) {
            log.warn("No social relationship addressed");
            response.sendError(404);
            return;
        }
        if (!"relationships".equals(info.getListType())) {
            log.warn("Only 'relationships' collection supported", (Object)info.getListType());
            response.sendError(404);
            return;
        }
        GraphNode other = graph.getNode(info.getOtherId());
        if (other == null) {
            log.warn("No social graph node for user {}", (Object)info.getOtherId());
            response.sendError(404);
            return;
        }
        Relationship rel = node.getRelationship(Direction.OUTGOING, other, info.getRelationshipType());
        if (rel == null) {
            try {
                rel = node.createRelationshipTo(other, info.getRelationshipType());
            }
            catch (SocialGraphException e) {
                log.error("Error creating the relationship", (Throwable)e);
                response.sendError(500);
            }
        }
        this.updateProperties(info, rel);
        graph.save();
        response.setStatus(200);
    }

    private void updateProperties(RequestInfo info, Map<String, Object> map) throws IOException {
        try {
            JSONObject obj = info.getJsonPost();
            JSONArray names = obj.names();
            if (names != null) {
                for (int i = 0; i < names.length(); ++i) {
                    String name = names.getString(i);
                    Object value = obj.get(name);
                    map.put(name, value);
                }
            }
        }
        catch (JSONException e) {
            IOException io = new IOException("Error while writing properties");
            io.initCause(e);
            throw io;
        }
    }
}

