/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.socialgraph.impl.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public class RequestInfo {
    public static final String RELATIONSHIPS_LIST_TYPE = "relationships";
    private final SlingHttpServletRequest request;
    private String extension;
    private String[] segs;
    private String id;
    private String listType;
    private String relationshipType;
    private String otherId;
    private JSONObject jsonPost;

    protected RequestInfo() {
        this.request = null;
    }

    public RequestInfo(SlingHttpServletRequest request) throws IOException {
        this.request = request;
        this.parseSuffix(request.getRequestPathInfo().getSuffix(), "GET".equals(request.getMethod()));
        if ("application/json".equals(request.getContentType())) {
            StringWriter json = new StringWriter();
            InputStreamReader in = new InputStreamReader((InputStream)request.getInputStream(), request.getCharacterEncoding());
            IOUtils.copy((Reader)in, (Writer)json);
            try {
                this.jsonPost = new JSONObject(json.toString());
            }
            catch (JSONException e) {
                IOException io = new IOException("Error while reading json input.");
                io.initCause(e);
                throw io;
            }
        } else {
            this.jsonPost = new JSONObject();
            for (String name : request.getRequestParameterMap().keySet()) {
                try {
                    this.jsonPost.put(name, (Object)request.getRequestParameter(name));
                }
                catch (JSONException e) {
                    IOException io = new IOException("Error while mapping input.");
                    io.initCause(e);
                    throw io;
                }
            }
        }
    }

    protected void parseSuffix(String suffix, boolean respectExtension) {
        int idx;
        if (suffix == null || suffix.length() == 0) {
            return;
        }
        if (respectExtension && (idx = suffix.lastIndexOf(46)) > 0) {
            this.extension = suffix.substring(idx + 1);
            suffix = suffix.substring(0, idx);
        }
        this.segs = Text.explode((String)suffix, (int)47);
        this.id = Text.unescapeIllegalJcrChars((String)this.segs[0]);
        if (this.segs.length > 1) {
            this.listType = this.segs[1];
        }
        if (this.segs.length > 2) {
            this.relationshipType = this.segs[2];
        }
        if (this.segs.length > 3) {
            this.otherId = Text.unescapeIllegalJcrChars((String)this.segs[3]);
        }
    }

    public SlingHttpServletRequest getRequest() {
        return this.request;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getId() {
        return this.id;
    }

    public String getListType() {
        return this.listType;
    }

    public String getRelationshipType() {
        return this.relationshipType;
    }

    public String getOtherId() {
        return this.otherId;
    }

    public JSONObject getJsonPost() {
        return this.jsonPost;
    }

    public String[] getSegments() {
        return this.segs;
    }
}

