/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.testing.assertion;

import com.adobe.granite.testing.ClientException;
import com.adobe.granite.testing.client.GraniteClient;
import com.adobe.granite.testing.json.JsonSchemaValidator;
import com.adobe.granite.testing.json.SchemaValidationResult;
import com.adobe.granite.testing.util.HttpUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.http.HttpResponse;
import org.apache.sling.testing.tools.retry.RetryLoop;
import org.apache.sling.testing.tools.sling.TimeoutsProvider;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.PrettyPrinter;
import org.codehaus.jackson.impl.DefaultPrettyPrinter;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ContainerNode;
import org.codehaus.jackson.node.ObjectNode;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraniteAssert {
    public static void assertPathDoesNotExist(final GraniteClient client, final String path, final int timeoutSec, int intervalRetryMilliSec) {
        RetryLoop.Condition c = new RetryLoop.Condition(){

            public String getDescription() {
                return "Node at " + path + " still exits after " + timeoutSec + " seconds.";
            }

            public boolean isTrue() throws Exception {
                return !client.exists(path);
            }
        };
        new RetryLoop(c, TimeoutsProvider.getInstance().getTimeout(timeoutSec), TimeoutsProvider.getInstance().getTimeout(intervalRetryMilliSec));
    }

    public static void assertPathExists(final GraniteClient client, final String path, final int timeoutSec, int intervalRetryMilliSec) {
        RetryLoop.Condition c = new RetryLoop.Condition(){

            public String getDescription() {
                return "Node at " + path + " not found after " + timeoutSec + " seconds.";
            }

            public boolean isTrue() throws Exception {
                return client.exists(path);
            }
        };
        new RetryLoop(c, TimeoutsProvider.getInstance().getTimeout(timeoutSec), TimeoutsProvider.getInstance().getTimeout(intervalRetryMilliSec));
    }

    public static void assertRegExMatch(String toValidate, String pattern) {
        GraniteAssert.assertRegExMatch(null, toValidate, pattern);
    }

    public static void assertRegExMatch(String message, String toValidate, String pattern) {
        GraniteAssert.assertRegExMatch(message, toValidate, Pattern.compile(pattern, 32));
    }

    public static void assertRegExMatch(String toValidate, Pattern pattern) {
        GraniteAssert.assertRegExMatch(null, toValidate, pattern);
    }

    public static void assertRegExMatch(String message, String toValidate, Pattern pattern) {
        if (toValidate == null) {
            Assert.fail((String)"the string to validate must not be null");
        }
        if (pattern == null) {
            Assert.fail((String)"the pattern to test the string against must not be null");
        }
        if (!pattern.matcher(toValidate).matches()) {
            Assert.fail((String)message);
        }
    }

    public static void assertRegExNoMatch(String message, String toValidate, Pattern pattern) {
        if (toValidate == null) {
            Assert.fail((String)"the string to validate must not be null");
        }
        if (pattern == null) {
            Assert.fail((String)"the pattern to test the string against must not be null");
        }
        if (pattern.matcher(toValidate).matches()) {
            Assert.fail((String)message);
        }
    }

    public static void assertRegExFind(String toValidate, String pattern) {
        GraniteAssert.assertRegExFind(null, toValidate, pattern);
    }

    public static void assertRegExFind(String message, String toValidate, String pattern) {
        GraniteAssert.assertRegExFind(message, toValidate, Pattern.compile(pattern, 32));
    }

    public static void assertRegExFind(String toValidate, Pattern pattern) {
        GraniteAssert.assertRegExFind(null, toValidate, pattern);
    }

    public static void assertRegExFind(String message, String toValidate, Pattern pattern) {
        if (toValidate == null) {
            Assert.fail((String)"the string to validate must not be null");
        }
        if (pattern == null) {
            Assert.fail((String)"the pattern to test the string against must not be null");
        }
        if (!pattern.matcher(toValidate).find()) {
            Assert.fail((String)message);
        }
    }

    public static void assertRegExNoFind(String message, String toValidate, Pattern pattern) {
        if (toValidate == null) {
            Assert.fail((String)"the string to validate must not be null");
        }
        if (pattern == null) {
            Assert.fail((String)"the pattern to test the string against must not be null");
        }
        if (pattern.matcher(toValidate).matches()) {
            Assert.fail((String)message);
        }
    }

    public static void assertStatusCode(HttpResponse httpResponse, int statusCode) {
        GraniteAssert.assertStatusCode(null, httpResponse, new int[]{statusCode});
    }

    public static void assertStatusCode(String message, HttpResponse httpResponse, int statusCode) {
        GraniteAssert.assertStatusCode(null, httpResponse, new int[]{statusCode});
    }

    public static void assertStatusCode(HttpResponse httpResponse, int[] statusCodes) {
        GraniteAssert.assertStatusCode(null, httpResponse, statusCodes);
    }

    public static void assertStatusCode(String message, HttpResponse httpResponse, int[] statusCodes) {
        if (httpResponse == null) {
            Assert.fail((String)"the http response to test for return codes must not be null");
        }
        if (statusCodes == null) {
            Assert.fail((String)"the codes to test the response against must not be null");
        }
        try {
            HttpUtils.verifyHttpStatus(httpResponse, message, statusCodes);
        }
        catch (ClientException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static void assertSchemaValid(String toValidate, String schemaFile) {
        try {
            SchemaValidationResult validationResult = new JsonSchemaValidator().validate(toValidate, schemaFile);
            if (!validationResult.isValid()) {
                Assert.fail((String)("result is not schema valid. " + validationResult));
            }
        }
        catch (Exception e) {
            Assert.fail((String)("error during schema validation. cause: " + e));
        }
    }

    public static void assertJsonEquals(String jsonString1, String jsonString2, List<String> ignoreProperties) {
        GraniteAssert.assertJsonEquals(jsonString1, jsonString2, ignoreProperties, null);
    }

    public static void assertJsonEquals(String jsonString1, String jsonString2, List<String> ignoreProperties, List<String> ignoreNodes) {
        if (jsonString1 == null || jsonString2 == null) {
            Assert.fail((String)"the json strings to compare for equality must not be null");
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode jsonTree1 = mapper.readTree(jsonString1);
            JsonNode jsonTree2 = mapper.readTree(jsonString2);
            GraniteAssert.removeProperties(jsonTree1, ignoreProperties);
            GraniteAssert.removeProperties(jsonTree2, ignoreProperties);
            GraniteAssert.removeNodes(jsonTree1, ignoreNodes);
            GraniteAssert.removeNodes(jsonTree2, ignoreNodes);
            if (!jsonTree1.equals((Object)jsonTree2)) {
                Assert.fail((String)("\nThis json data:\n" + GraniteAssert.prettyPrint(mapper, jsonTree1) + "\n\nis not equal to that one:\n" + GraniteAssert.prettyPrint(mapper, jsonTree2) + "\n"));
            }
        }
        catch (Exception e) {
            Assert.fail((String)("there was an error when trying to compare. reason: " + e));
        }
    }

    private static String prettyPrint(ObjectMapper mapper, JsonNode node) throws IOException {
        StringWriter w = new StringWriter();
        JsonGenerator g = mapper.getJsonFactory().createJsonGenerator((Writer)w);
        g.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
        mapper.writeTree(g, node);
        return w.toString();
    }

    public static void assertJsonEquals(String jsonString1, String jsonString2) {
        GraniteAssert.assertJsonEquals(jsonString1, jsonString2, null, null);
    }

    private static void removeProperties(JsonNode baseNode, List<String> ignoreProperties) {
        if (ignoreProperties == null) {
            return;
        }
        for (String ignoreProperty : ignoreProperties) {
            JsonNode ignoreNode = baseNode.get(ignoreProperty);
            if (ignoreNode == null) continue;
            ((ObjectNode)baseNode).remove(ignoreProperty);
        }
        for (JsonNode node : baseNode) {
            if (!(node instanceof ContainerNode)) continue;
            GraniteAssert.removeProperties(node, ignoreProperties);
        }
    }

    private static void removeNodes(JsonNode baseNode, List<String> ignoreNodes) {
        if (ignoreNodes == null) {
            return;
        }
        for (String ignoreNodeName : ignoreNodes) {
            JsonNode ignoreNode = baseNode.get(ignoreNodeName);
            if (ignoreNode == null) continue;
            ((ObjectNode)baseNode).remove(ignoreNodeName);
        }
        for (JsonNode node : baseNode) {
            if (!(node instanceof ContainerNode)) continue;
            GraniteAssert.removeNodes(node, ignoreNodes);
        }
    }

    public static void assertIsAgentEnabled(GraniteClient client, String agentPath) {
        JsonNode node = null;
        try {
            node = client.getJsonNode(agentPath + ".1.json", 1);
        }
        catch (ClientException e) {
            e.printStackTrace();
            Assert.fail((String)("Requesting " + agentPath + ".1.json failed!: " + e.getMessage()));
        }
        node = node.get("jcr:content");
        Assert.assertFalse((String)("Missing " + agentPath + "/jcr:content !"), (boolean)node.isMissingNode());
        node = node.get("enabled");
        Assert.assertFalse((String)("Missing " + agentPath + "/jcr:content/enabled !"), (boolean)node.isMissingNode());
        Assert.assertEquals((String)("Agent " + agentPath + " is not enabled!"), (Object)"true", (Object)node.getValueAsText());
    }
}

