/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.testing.client;

import com.adobe.granite.testing.ClientException;
import com.adobe.granite.testing.client.ClientManager;
import com.adobe.granite.testing.client.HttpHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraniteClient {
    protected String serverUrl;
    protected String rootContext;
    protected String user;
    protected String password;
    public final HttpHandler http;
    ClientManager clientMgr = ClientManager.getClientManager();
    private String clientId;

    public AbstractGraniteClient(String baseUrl, String rootContext, String user, String password) {
        this.serverUrl = baseUrl;
        this.rootContext = rootContext;
        this.user = user;
        this.password = password;
        this.clientId = this.clientMgr.addClient(this);
        this.http = new HttpHandler(this);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getRootContext() {
        return this.rootContext;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String externalizeToContextPath(String path) {
        if (path.indexOf("/") != 0) {
            return path;
        }
        return this.getRootContext() + path;
    }

    public String getUri(String path) {
        if (path.indexOf("/") != 0) {
            return path;
        }
        return this.getServerUrl() + this.getRootContext() + path;
    }

    protected String getClientId() {
        return this.clientId;
    }

    public <T extends AbstractGraniteClient> T getClient(Class<T> clientClass) throws ClientException {
        return this.clientMgr.getClient(clientClass, this.getServerUrl(), this.getRootContext(), this.getUser(), this.getPassword());
    }
}

