/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.testing.client;

import com.adobe.granite.testing.ClientException;
import com.adobe.granite.testing.client.AbstractGraniteClient;
import java.lang.reflect.Constructor;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientManager {
    private static HashMap clientCache = new HashMap();
    private static ClientManager mgr = null;

    private ClientManager() {
    }

    public static ClientManager getClientManager() {
        if (mgr == null) {
            mgr = new ClientManager();
        }
        return mgr;
    }

    public HashMap getCache() {
        return clientCache;
    }

    public <T extends AbstractGraniteClient> T getClient(Class<T> clientClass, String serverUrl, String rootContext, String user, String password) throws ClientException {
        String generatedClientId = this.generateClientId(clientClass, serverUrl, rootContext, user, password);
        T client = mgr.containsClient(generatedClientId) ? mgr.getClient(generatedClientId) : this.createClient(clientClass, serverUrl, rootContext, user, password);
        return client;
    }

    protected <T extends AbstractGraniteClient> T getClient(String clientId) {
        AbstractGraniteClient client = null;
        if (this.containsClient(clientId)) {
            client = (AbstractGraniteClient)clientCache.get(clientId);
        }
        return (T)client;
    }

    protected <T extends AbstractGraniteClient> T createClient(Class<T> clientClass, String serverUrl, String rootContext, String user, String password) throws ClientException {
        AbstractGraniteClient client;
        try {
            Constructor<T> cons = clientClass.getConstructor(String.class, String.class, String.class, String.class);
            client = (AbstractGraniteClient)cons.newInstance(serverUrl, rootContext, user, password);
        }
        catch (Exception e) {
            throw new ClientException("Could not initialize client: '" + clientClass.getCanonicalName() + "'.", e);
        }
        return (T)client;
    }

    public boolean containsClient(String clientId) {
        return clientCache.containsKey(clientId);
    }

    public <T extends AbstractGraniteClient> String addClient(T client) {
        String clientId = this.generateClientId(client);
        if (!this.containsClient(clientId)) {
            clientCache.put(clientId, client);
        }
        return clientId;
    }

    public void removeClient(String clientId) {
        if (this.containsClient(clientId)) {
            clientCache.remove(clientId);
        }
    }

    public void clearCache() {
        clientCache.clear();
    }

    protected <T extends AbstractGraniteClient> String generateClientId(T client) {
        return this.generateClientId(client.getClass(), client.getServerUrl(), client.getRootContext(), client.getUser(), client.getPassword());
    }

    protected String generateClientId(Class clientClass, String baseUrl, String rootContext, String user, String password) {
        return clientClass.getCanonicalName() + baseUrl + rootContext + user + password;
    }
}

