/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.testing.client;

import com.adobe.granite.testing.ClientException;
import com.adobe.granite.testing.client.AbstractGraniteClient;
import com.adobe.granite.testing.util.FormEntityBuilder;
import com.adobe.granite.testing.util.HttpUtils;
import com.adobe.granite.testing.util.JsonUtils;
import com.adobe.granite.testing.util.RequestExecutorStream;
import com.adobe.granite.testing.util.SlingResponseHandler;
import com.adobe.granite.testing.util.URLParameterBuilder;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Stack;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.sling.testing.tools.http.RequestExecutor;
import org.apache.sling.testing.tools.retry.RetryLoop;
import org.apache.sling.testing.tools.sling.TimeoutsProvider;
import org.codehaus.jackson.JsonNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraniteClient
extends AbstractGraniteClient {
    public GraniteClient(String baseUrl, String rootContext, String user, String password) {
        super(baseUrl, rootContext, user, password);
    }

    public void move(String srcPath, String destPath) throws ClientException {
        FormEntityBuilder feb = new FormEntityBuilder().addParameter(":operation", "move").addParameter(":dest", destPath);
        RequestExecutor exec = this.http.doPost(srcPath, (HttpEntity)feb.getEntity(), new int[0]);
        HttpUtils.verifyHttpStatusRange(exec, 200);
    }

    public void delete(String path) throws ClientException {
        FormEntityBuilder feb = new FormEntityBuilder().addParameter(":operation", "delete");
        RequestExecutor exec = this.http.doPost(path, (HttpEntity)feb.getEntity(), new int[0]);
        HttpUtils.verifyHttpStatusRange(exec, 200);
    }

    public void createNodes(String path, String nodeType) throws ClientException {
        Stack<String> parents = new Stack<String>();
        path = this.getParentPath(path);
        while (path.length() > 0) {
            parents.push(path);
            path = this.getParentPath(path);
        }
        while (!parents.isEmpty()) {
            if (nodeType == null) {
                parents.pop();
                continue;
            }
            this.createNode((String)parents.pop(), nodeType);
        }
    }

    public void createNode(String path, String nodeType) throws ClientException {
        if (!this.exists(path)) {
            RequestExecutor exec;
            FormEntityBuilder feb = null;
            if (nodeType != null) {
                feb = new FormEntityBuilder().addParameter("jcr:primaryType", nodeType);
                exec = this.http.doPost(path, (HttpEntity)feb.getEntity(), new int[0]);
            } else {
                exec = this.http.doPost(path, null, new int[0]);
            }
            HttpUtils.verifyHttpStatusRange(exec, 200);
        }
    }

    public boolean exists(String path) throws ClientException {
        RequestExecutor exec = this.http.doGet(path + ".json", new int[0]);
        int status = exec.getResponse().getStatusLine().getStatusCode();
        return status == 200;
    }

    protected String getParentPath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos > 0) {
            return path.substring(0, pos);
        }
        return "";
    }

    public void exists(final String path, final int timeoutSeconds, int intervalRetryMillSec) throws ClientException {
        RetryLoop.Condition c = new RetryLoop.Condition(){

            public String getDescription() {
                return "Handle " + path + " not found after " + timeoutSeconds + " seconds.";
            }

            public boolean isTrue() throws Exception {
                return GraniteClient.this.exists(path);
            }
        };
        new RetryLoop(c, TimeoutsProvider.getInstance().getTimeout(timeoutSeconds), TimeoutsProvider.getInstance().getTimeout(intervalRetryMillSec));
    }

    public SlingResponseHandler setPropertyString(String nodePath, String propName, String propValue, int ... expectedStatus) throws ClientException {
        FormEntityBuilder formEntry = new FormEntityBuilder();
        formEntry.addParameter(propName, propValue);
        RequestExecutor exec = this.http.doPost(nodePath, (HttpEntity)formEntry.getEntity(), new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return HttpUtils.getSlingResponseHandler(exec);
    }

    public SlingResponseHandler setPropertyStringArray(String nodePath, String propName, List<String> propValueList, int ... expectedStatus) throws ClientException {
        FormEntityBuilder formEntry = new FormEntityBuilder();
        if (propValueList != null) {
            for (int i = 0; i < propValueList.size(); ++i) {
                formEntry.addParameter(propName, propValueList.get(i));
            }
        }
        RequestExecutor exec = this.http.doPost(nodePath, (HttpEntity)formEntry.getEntity(), new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return HttpUtils.getSlingResponseHandler(exec);
    }

    public JsonNode getJsonNode(String path, int depth) throws ClientException {
        return this.getJsonNode(path, depth, 30, 500, new int[0]);
    }

    public JsonNode getJsonNode(String path, int depth, int timeoutSec, int intervalRetryMillSec, int ... expectedStatus) throws ClientException {
        String jsonString = "";
        path = depth == -1 ? path + ".infinity.json" : path + "." + depth + ".json";
        String finalPath = path.substring(0, path.lastIndexOf("."));
        this.exists(finalPath, timeoutSec, intervalRetryMillSec);
        RequestExecutor exec = this.http.doGet(path, new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return JsonUtils.getJsonNodeFromString(exec.getContent());
    }

    public SlingResponseHandler upload(File file, String mimeType, String toPath, boolean createFolders, int ... expectedStatus) throws ClientException {
        String toFileName = URIUtil.getName((String)toPath);
        if (toFileName == null || toFileName.length() == 0) {
            toFileName = file.getName();
        }
        toPath = this.getParentPath(toPath);
        if (createFolders) {
            this.createNodes(this.getParentPath(toPath), "sling:OrderedFolder");
        }
        MultipartEntity entity = new MultipartEntity();
        FileBody fileBody = mimeType == null ? new FileBody(file) : new FileBody(file, mimeType);
        entity.addPart(toFileName, (ContentBody)fileBody);
        RequestExecutor exec = this.http.doPost(toPath, (HttpEntity)entity, new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(201, expectedStatus));
        return HttpUtils.getSlingResponseHandler(exec);
    }

    public SlingResponseHandler createFolder(String folderName, String folderTitle, String parentPath, int ... expectedStatus) throws ClientException {
        String folderPath = parentPath + "/" + folderName;
        FormEntityBuilder feb = new FormEntityBuilder().addParameter("./jcr:primaryType", "sling:OrderedFolder").addParameter("./jcr:content/jcr:primaryType", "nt:unstructured").addParameter("./jcr:content/jcr:title", folderTitle);
        RequestExecutor exec = this.http.doPost(folderPath, (HttpEntity)feb.getEntity(), new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(201, expectedStatus));
        return HttpUtils.getSlingResponseHandler(exec);
    }

    public InputStream getBinary(String path, List<NameValuePair> parameters, int ... expectedStatus) throws ClientException {
        URLParameterBuilder params = new URLParameterBuilder();
        String paramString = "";
        if (parameters != null) {
            params.add(parameters);
            paramString = "?" + params.getURLParameters();
        }
        boolean getStreamResponse = true;
        RequestExecutorStream exec = (RequestExecutorStream)((Object)this.http.doGet(path + paramString, null, null, false, getStreamResponse, new int[0]));
        HttpUtils.verifyHttpStatus(exec.getResponse(), HttpUtils.getExpectedStatus(200, expectedStatus));
        return exec.getContentAsStream();
    }

    public String getUUID(String repPath) throws ClientException {
        if (!this.exists(repPath)) {
            return null;
        }
        JsonNode jsonNode = this.getJsonNode(repPath, -1);
        return this.getUUId(jsonNode);
    }

    public String getUUId(JsonNode jsonNode) throws ClientException {
        if (jsonNode == null) {
            return null;
        }
        JsonNode uuidNode = jsonNode.get("jcr:uuid");
        String uuid = null;
        if (uuidNode != null) {
            uuid = uuidNode.getValueAsText();
        }
        return uuid;
    }
}

