/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.testing.client;

import com.adobe.granite.testing.ClientException;
import com.adobe.granite.testing.client.AbstractGraniteClient;
import com.adobe.granite.testing.util.HttpUtils;
import com.adobe.granite.testing.util.RequestExecutorStream;
import com.adobe.granite.testing.util.URLParameterBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.sling.testing.tools.http.Request;
import org.apache.sling.testing.tools.http.RequestBuilder;
import org.apache.sling.testing.tools.http.RequestExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHandler {
    private AbstractGraniteClient client;
    DefaultHttpClient httpClient = new DefaultHttpClient();
    RequestExecutor requestExecutor = new RequestExecutor(this.httpClient);
    RequestExecutorStream requestExecutorStream = new RequestExecutorStream(this.httpClient);
    RequestBuilder builder;

    public HttpHandler(AbstractGraniteClient client) {
        this.builder = new RequestBuilder(client.getServerUrl() + client.getRootContext());
        this.client = client;
    }

    public AbstractGraniteClient getClient() {
        return this.client;
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    public RequestExecutor getRequestExecutor() {
        return this.requestExecutor;
    }

    public RequestExecutorStream getRequestExecutorStream() {
        return this.requestExecutorStream;
    }

    public RequestBuilder getRequestBuilder() {
        return this.builder;
    }

    public <T extends RequestExecutor> T doGet(String requestPath, String[] parameters, String[] headers, boolean followRedirects, boolean getStreamResponse, int ... expectedStatus) throws ClientException {
        Request request = this.builder.buildGetRequest(requestPath, parameters);
        request.withCredentials(this.client.getUser(), this.client.getPassword());
        this.setHeaders(request, headers);
        request.withRedirects(followRedirects);
        T exec = this.execute(request, getStreamResponse);
        if (expectedStatus != null && expectedStatus.length > 0) {
            HttpUtils.verifyHttpStatus(exec, expectedStatus);
        }
        return exec;
    }

    public <T extends RequestExecutor> T doPost(String requestPath, HttpEntity entity, String[] headers, boolean followRedirects, boolean getStreamResponse, int ... expectedStatus) throws ClientException {
        Request request = this.builder.buildPostRequest(requestPath);
        request.withCredentials(this.client.getUser(), this.client.getPassword());
        this.setHeaders(request, headers);
        request.withRedirects(followRedirects);
        this.setEntity(entity, request);
        T exec = this.execute(request, getStreamResponse);
        if (expectedStatus != null && expectedStatus.length > 0) {
            HttpUtils.verifyHttpStatus(exec, expectedStatus);
        }
        return exec;
    }

    public <T extends RequestExecutor> T execute(Request request, boolean getStreamResponse) throws ClientException {
        T exec = this.getRequestExecutor(getStreamResponse);
        try {
            exec.execute(request);
        }
        catch (Exception e) {
            throw new ClientException(String.format(request.getRequest().getMethod() + " request to '%s' failed! : " + HttpUtils.buildDefaultErrorMessage(exec), request.getRequest().getURI().toString()), e);
        }
        return exec;
    }

    public RequestExecutor doGet(String requestPath, int ... expectedStatus) throws ClientException {
        String[] parameters = null;
        String[] headers = null;
        boolean followRedirects = false;
        boolean getStreamResponse = false;
        return this.doGet(requestPath, parameters, headers, followRedirects, getStreamResponse, expectedStatus);
    }

    public RequestExecutor doGet(String requestPath, URLParameterBuilder parameters, int ... expectedStatus) throws ClientException {
        String paramaters;
        String paramString = "";
        if (parameters != null && (paramaters = parameters.getURLParameters()).length() > 0) {
            paramString = "?" + paramaters;
        }
        return this.doGet(requestPath + paramString, expectedStatus);
    }

    public RequestExecutor doGet(String requestPath, String[] parameters, int ... expectedStatus) throws ClientException {
        String[] headers = null;
        boolean followRedirects = false;
        boolean getStreamResponse = false;
        return this.doGet(requestPath, parameters, headers, followRedirects, getStreamResponse, new int[0]);
    }

    public RequestExecutor doPost(String requestPath, HttpEntity entity, int ... expectedStatus) throws ClientException {
        String[] headers = null;
        boolean followRedirects = false;
        boolean getStreamResponse = false;
        return this.doPost(requestPath, entity, headers, followRedirects, getStreamResponse, expectedStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGetRaw(String urlPath) throws IOException {
        URL url = new URL(this.client.getServerUrl() + this.client.getRootContext());
        String hostname = url.getHost();
        int port = url.getPort();
        Socket socket = null;
        PrintWriter writer = null;
        BufferedReader reader = null;
        String response = "";
        try {
            String line;
            socket = new Socket(hostname, port);
            writer = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
            writer.println("GET " + this.client.getUri(urlPath) + " HTTP/1.1");
            writer.println("Host: " + hostname + ":" + port);
            writer.println("Accept: */*");
            writer.println("User-Agent: Java");
            writer.println("");
            writer.flush();
            reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while ((line = reader.readLine()) != null) {
                response = response + line;
                writer.write(line + "\r\n");
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (writer != null) {
                writer.close();
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return response;
    }

    protected <T extends RequestExecutor> T getRequestExecutor(boolean getStreamResponse) {
        RequestExecutor exec = this.requestExecutor;
        if (getStreamResponse) {
            exec = this.requestExecutorStream;
        }
        return (T)exec;
    }

    protected Request setHeaders(Request request, String ... headers) {
        if (headers == null || headers.length == 0) {
            return request;
        }
        if (headers.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid number of header arguments (" + headers.length + "), must be even");
        }
        for (int i = 0; i < headers.length; i += 2) {
            request.withHeader(headers[i], headers[i + 1]);
        }
        return request;
    }

    protected void setEntity(HttpEntity entity, Request request) throws ClientException {
        if (entity != null) {
            try {
                request.withEntity(entity);
            }
            catch (UnsupportedEncodingException e) {
                throw new ClientException("Could not add HttpEntity to POST Request!", e);
            }
        }
    }
}

