/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.testing.client;

import com.adobe.granite.testing.ClientException;
import com.adobe.granite.testing.client.GraniteClient;
import com.adobe.granite.testing.util.FormEntityBuilder;
import com.adobe.granite.testing.util.HttpUtils;
import com.adobe.granite.testing.util.InputStreamBodyWithLength;
import com.adobe.granite.testing.util.SlingResponseHandler;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.NotImplementedException;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.sling.testing.tools.http.RequestExecutor;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class PackageManagerClient
extends GraniteClient {
    public PackageManagerClient(String baseUrl, String rootContext, String user, String password) {
        super(baseUrl, rootContext, user, password);
    }

    public Package createPackage(String name, String version, String group) throws ClientException {
        FormEntityBuilder feb = new FormEntityBuilder();
        feb.addParameter("cmd", "create");
        feb.addParameter("_charset_", "utf-8");
        feb.addParameter("groupName", group);
        feb.addParameter("packageName", name);
        if (version != null) {
            feb.addParameter("packageVersion", version);
        }
        this.http.doPost("/crx/packmgr/service/exec.json", (HttpEntity)feb.getEntity(), 200);
        return new Package(this, name, version, group);
    }

    public Package getPackage(String path) throws ClientException {
        return new Package(this, path);
    }

    public Package uploadPackage(InputStream is, String fileName) throws ClientException {
        JsonNode root;
        FormBodyPart fbp;
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("package", (ContentBody)new InputStreamBody(is, fileName));
        try {
            fbp = new FormBodyPart("_charset_", (ContentBody)new StringBody("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new ClientException("Unsupported encoding (should not happen).", ex);
        }
        mpe.addPart(fbp);
        RequestExecutor exec = this.http.doPost("/crx/packmgr/service/exec.json?cmd=upload&jsonInTextarea=true", (HttpEntity)mpe, 200);
        ObjectMapper mapper = new ObjectMapper();
        try {
            root = mapper.readTree(exec.getContent().replaceAll("</?textarea>", ""));
        }
        catch (Exception ex) {
            throw new ClientException("Unable to parse JSON response to upload request.", ex);
        }
        if (!root.get("success").getBooleanValue()) {
            throw new ClientException(root.get("msg").getTextValue());
        }
        return new Package(this, root.get("path").getTextValue());
    }

    public SlingResponseHandler createPackage(String packageName, String packageVersion, String groupName, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = new FormEntityBuilder().addParameter("_charset_", "utf-8").addParameter("packageName", packageName).addParameter("packageVersion", packageVersion).addParameter("groupName", groupName);
        RequestExecutor exec = this.http.doPost("/crx/packmgr/service/exec.json?cmd=create", (HttpEntity)feb.getEntity(), new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return HttpUtils.getSlingResponseHandler(exec);
    }

    public SlingResponseHandler deletePackage(String packageName, String packageVersion, String groupName, int ... expectedStatus) throws ClientException, UnsupportedEncodingException {
        String URL2 = "/crx/packmgr/service/script.html/etc/packages/" + groupName + "/" + packageName + "-" + packageVersion + ".zip";
        MultipartEntity multiPartEntity = new MultipartEntity();
        multiPartEntity.addPart("cmd", (ContentBody)new StringBody("delete"));
        multiPartEntity.addPart("callback", (ContentBody)new StringBody("window.parent.Ext.Ajax.Stream.callback"));
        RequestExecutor exec = this.http.doPost(URL2, (HttpEntity)multiPartEntity, new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return HttpUtils.getSlingResponseHandler(exec);
    }

    public SlingResponseHandler renamePackages(String oldName, String oldVersion, String oldGroup, String newName, String newVersion, String newGroup, int ... expectedStatus) throws UnsupportedEncodingException, ClientException {
        String oldPath = "/etc/packages/" + oldGroup + "/" + oldName + "-" + oldVersion + ".zip";
        MultipartEntity multiPartEntity = new MultipartEntity();
        multiPartEntity.addPart("path", (ContentBody)new StringBody(oldPath));
        multiPartEntity.addPart("packageName", (ContentBody)new StringBody(newName));
        multiPartEntity.addPart("groupName", (ContentBody)new StringBody(newGroup));
        multiPartEntity.addPart("version", (ContentBody)new StringBody(newVersion));
        multiPartEntity.addPart("_charset_", (ContentBody)new StringBody("UTF-8"));
        RequestExecutor exec = this.http.doPost("/crx/packmgr/update.jsp", (HttpEntity)multiPartEntity, new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return HttpUtils.getSlingResponseHandler(exec);
    }

    public boolean isPackageCreated(String packageName, String packageVersion, String groupName) throws ClientException {
        return this.exists("/etc/packages/" + groupName + "/" + packageName + "-" + packageVersion + ".zip");
    }

    public SlingResponseHandler buildPackage(String packageName, String packageVersion, String groupName, int ... expectedStatus) throws ClientException, UnsupportedEncodingException {
        String postURL = "/crx/packmgr/service/script.html/etc/packages/" + groupName + "/" + packageName + "-" + packageVersion + ".zip";
        MultipartEntity multiPartEntity = new MultipartEntity();
        multiPartEntity.addPart("cmd", (ContentBody)new StringBody("build"));
        multiPartEntity.addPart("callback", (ContentBody)new StringBody("window.parent.Ext.Ajax.Stream.callback"));
        RequestExecutor exec = this.http.doPost(postURL, (HttpEntity)multiPartEntity, new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return HttpUtils.getSlingResponseHandler(exec);
    }

    public SlingResponseHandler rewrapPackage(String packageName, String packageVersion, String groupName, int ... expectedStatus) throws ClientException, UnsupportedEncodingException {
        String postURL = "/crx/packmgr/service/script.html/etc/packages/" + groupName + "/" + packageName + "-" + packageVersion + ".zip";
        MultipartEntity multiPartEntity = new MultipartEntity();
        multiPartEntity.addPart("cmd", (ContentBody)new StringBody("rewrap"));
        multiPartEntity.addPart("callback", (ContentBody)new StringBody("window.parent.Ext.Ajax.Stream.callback"));
        RequestExecutor exec = this.http.doPost(postURL, (HttpEntity)multiPartEntity, new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return HttpUtils.getSlingResponseHandler(exec);
    }

    public SlingResponseHandler installPackage(String packageName, String packageVersion, String groupName, int ... expectedStatus) throws ClientException, UnsupportedEncodingException {
        String postURL = "/crx/packmgr/service/script.html/etc/packages/" + groupName + "/" + packageName + "-" + packageVersion + ".zip";
        MultipartEntity multiPartEntity = new MultipartEntity();
        multiPartEntity.addPart("cmd", (ContentBody)new StringBody("install"));
        multiPartEntity.addPart("callback", (ContentBody)new StringBody("window.parent.Ext.Ajax.Stream.callback"));
        multiPartEntity.addPart("autosave", (ContentBody)new StringBody("1024"));
        multiPartEntity.addPart("recursive", (ContentBody)new StringBody("true"));
        RequestExecutor exec = this.http.doPost(postURL, (HttpEntity)multiPartEntity, new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return HttpUtils.getSlingResponseHandler(exec);
    }

    public SlingResponseHandler uninstallPackage(String packageName, String packageVersion, String groupName, int ... expectedStatus) throws ClientException, UnsupportedEncodingException {
        String postURL = "/crx/packmgr/service/script.html/etc/packages/" + groupName + "/" + packageName + "-" + packageVersion + ".zip";
        MultipartEntity multiPartEntity = new MultipartEntity();
        multiPartEntity.addPart("cmd", (ContentBody)new StringBody("uninstall"));
        multiPartEntity.addPart("callback", (ContentBody)new StringBody("window.parent.Ext.Ajax.Stream.callback"));
        RequestExecutor exec = this.http.doPost(postURL, (HttpEntity)multiPartEntity, new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return HttpUtils.getSlingResponseHandler(exec);
    }

    public SlingResponseHandler testInstallPackage(String packageName, String packageVersion, String groupName, int ... expectedStatus) throws ClientException, UnsupportedEncodingException {
        String postURL = "/crx/packmgr/service/script.html/etc/packages/" + groupName + "/" + packageName + "-" + packageVersion + ".zip";
        MultipartEntity multiPartEntity = new MultipartEntity();
        multiPartEntity.addPart("cmd", (ContentBody)new StringBody("dryrun"));
        multiPartEntity.addPart("callback", (ContentBody)new StringBody("window.parent.Ext.Ajax.Stream.callback"));
        RequestExecutor exec = this.http.doPost(postURL, (HttpEntity)multiPartEntity, new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return HttpUtils.getSlingResponseHandler(exec);
    }

    public SlingResponseHandler uploadPackage(String resourcePath, String fileName, int ... expectedStatus) throws UnsupportedEncodingException, ClientException {
        String postURL = "/crx/packmgr/service/exec.json?cmd=upload&jsonInTextarea=true";
        MultipartEntity multiPartEntity = new MultipartEntity();
        multiPartEntity.addPart("package", (ContentBody)new InputStreamBodyWithLength(resourcePath, "application/x-zip-compressed", fileName));
        multiPartEntity.addPart("force", (ContentBody)new StringBody("true"));
        multiPartEntity.addPart("_charset_", (ContentBody)new StringBody("UTF-8"));
        RequestExecutor exec = this.http.doPost(postURL, (HttpEntity)multiPartEntity, new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return HttpUtils.getSlingResponseHandler(exec);
    }

    public String getPackageContentResponse(String packageName, String packageVersion, String groupName) throws UnsupportedEncodingException, ClientException {
        String postURL = "/crx/packmgr/service/script.html/etc/packages/" + groupName + "/" + packageName + "-" + packageVersion + ".zip";
        MultipartEntity multiPartEntity = new MultipartEntity();
        multiPartEntity.addPart("cmd", (ContentBody)new StringBody("contents"));
        multiPartEntity.addPart("callback", (ContentBody)new StringBody("window.parent.Ext.Ajax.Stream.callback"));
        RequestExecutor exec = this.http.doPost(postURL, (HttpEntity)multiPartEntity, new int[0]);
        return exec.getContent();
    }

    public String getPackageCoverageResponse(String packageName, String packageVersion, String groupName) throws UnsupportedEncodingException, ClientException {
        String postURL = "/crx/packmgr/service/script.html/etc/packages/" + groupName + "/" + packageName + "-" + packageVersion + ".zip";
        MultipartEntity multiPartEntity = new MultipartEntity();
        multiPartEntity.addPart("cmd", (ContentBody)new StringBody("preview"));
        multiPartEntity.addPart("callback", (ContentBody)new StringBody("window.parent.Ext.Ajax.Stream.callback"));
        RequestExecutor exec = this.http.doPost(postURL, (HttpEntity)multiPartEntity, new int[0]);
        return exec.getContent();
    }

    public SlingResponseHandler updateThumbnail(String packageName, String packageVersion, String groupName, String resourcePath, String fileName, int ... expectedStatus) throws ClientException, UnsupportedEncodingException {
        String postURL = "/crx/packmgr/update.jsp";
        MultipartEntity multiPartEntity = new MultipartEntity();
        multiPartEntity.addPart("path", (ContentBody)new StringBody("/etc/packages/" + groupName + "/" + packageName + "-" + packageVersion + ".zip"));
        multiPartEntity.addPart("packageName", (ContentBody)new StringBody(packageName));
        multiPartEntity.addPart("groupName", (ContentBody)new StringBody(groupName));
        multiPartEntity.addPart("version", (ContentBody)new StringBody(packageVersion));
        multiPartEntity.addPart("_charset_", (ContentBody)new StringBody("UTF-8"));
        multiPartEntity.addPart("thumbnail", (ContentBody)new InputStreamBodyWithLength(resourcePath, "image/jpeg", fileName));
        RequestExecutor exec = this.http.doPost(postURL, (HttpEntity)multiPartEntity, new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return HttpUtils.getSlingResponseHandler(exec);
    }

    public SlingResponseHandler uploadPictureAsScreenshot(String packageName, String packageVersion, String groupName, String resourcePath, String fileName, int ... expectedStatus) throws UnsupportedEncodingException, ClientException {
        String postURL = "/crx/packmgr/update.jsp";
        MultipartEntity multiPartEntity = new MultipartEntity();
        multiPartEntity.addPart("path", (ContentBody)new StringBody("/etc/packages/" + groupName + "/" + packageName + "-" + packageVersion + ".zip"));
        multiPartEntity.addPart("packageName", (ContentBody)new StringBody(packageName));
        multiPartEntity.addPart("groupName", (ContentBody)new StringBody(groupName));
        multiPartEntity.addPart("version", (ContentBody)new StringBody(packageVersion));
        multiPartEntity.addPart("_charset_", (ContentBody)new StringBody("UTF-8"));
        multiPartEntity.addPart("screenshot", (ContentBody)new InputStreamBodyWithLength(resourcePath, "image/jpeg", fileName));
        multiPartEntity.addPart("screenshotConfig", (ContentBody)new StringBody("[{\"upload\":true}])"));
        RequestExecutor exec = this.http.doPost(postURL, (HttpEntity)multiPartEntity, new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return HttpUtils.getSlingResponseHandler(exec);
    }

    public static class Package {
        PackageManagerClient pm;
        String path;
        String name;
        String version;
        boolean versionUpdated;
        String group;
        String description;
        String filter;
        Date created;
        Date lastModified;
        Date lastWrapped;
        String lastWrappedBy;
        Date lastUnwrapped;
        String lastUnwrappedBy;
        Date lastUnpacked;
        String lastUnpackedBy;
        Boolean requiresRestart;
        Boolean requiresRoot;
        Integer buildCount;
        String builtWith;

        protected Package(PackageManagerClient pm, String name, String version, String group) {
            this.init(name, version, group, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }

        protected Package(PackageManagerClient pm, String path) throws ClientException {
            this.pm = pm;
            this.initAll(path);
        }

        private void initAll(String path) throws ClientException {
            String regexp = "/etc/packages/([^/]+)/([^\\-.]+)-?(.*).zip";
            Matcher re = Pattern.compile(regexp).matcher(path);
            if (!re.matches()) {
                throw new IllegalArgumentException("The path supplied does not look like a path to a package. It is expected to match " + regexp);
            }
            String resp = this.pm.http.doGet(path + "/jcr:content/vlt:definition.9.json", new int[0]).getContent();
            ObjectMapper mapper = new ObjectMapper();
            JsonNode packageDefinition = null;
            try {
                packageDefinition = mapper.readTree(resp);
            }
            catch (Exception ex) {
                throw new ClientException("Unable to load package properties", ex);
            }
            this.init(Package.getJsonStringSafely(packageDefinition, "name"), Package.getJsonStringSafely(packageDefinition, "version"), Package.getJsonStringSafely(packageDefinition, "group"), Package.getJsonStringSafely(packageDefinition, "jcr:description"), Package.getJsonStringSafely(packageDefinition, "filter"), Package.getJsonDateSafely(packageDefinition, "jcr:created"), Package.getJsonDateSafely(packageDefinition, "jcr:lastModified"), Package.getJsonDateSafely(packageDefinition, "lastWrapped"), Package.getJsonStringSafely(packageDefinition, "lastWrappedBy"), Package.getJsonDateSafely(packageDefinition, "lastUnwrapped"), Package.getJsonStringSafely(packageDefinition, "lastUnwrappedBy"), Package.getJsonDateSafely(packageDefinition, "lastUnpacked"), Package.getJsonStringSafely(packageDefinition, "lastUnpackedBy"), Package.getJsonBooleanSafely(packageDefinition, "requiresRestart"), Package.getJsonBooleanSafely(packageDefinition, "requiresRoot"), Package.getJsonIntegerSafely(packageDefinition, "buildCount"), Package.getJsonStringSafely(packageDefinition, "builtWith"));
        }

        private void init(String name, String version, String group, String description, String filter, Date created, Date lastModified, Date lastWrapped, String lastWrappedBy, Date lastUnwrapped, String lastUnwrappedBy, Date lastUnpacked, String lastUnpackedBy, Boolean requiresRestart, Boolean requiresRoot, Integer buildCount, String builtWith) {
            this.name = name;
            this.version = version;
            this.group = group;
            this.description = description;
            this.filter = filter;
            this.path = this.buildPath();
            this.created = created;
            this.lastModified = lastModified;
            this.lastWrapped = lastWrapped;
            this.lastWrappedBy = lastWrappedBy;
            this.lastUnwrapped = lastUnwrapped;
            this.lastUnwrappedBy = lastUnwrappedBy;
            this.lastUnpacked = lastUnpacked;
            this.lastUnpackedBy = lastUnpackedBy;
            this.requiresRestart = requiresRestart;
            this.requiresRoot = requiresRoot;
            this.buildCount = buildCount;
            this.builtWith = builtWith;
            this.versionUpdated = false;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Package)) {
                return false;
            }
            Package that = (Package)other;
            return !(this.name != that.name && !this.name.equals(that.name) || this.version != that.version && !this.version.equals(that.version) || this.group != that.group && !this.group.equals(that.group) || this.description != that.description && !this.description.equals(that.description) || this.filter != that.filter && !this.filter.equals(that.filter) || this.path != that.path && !this.path.equals(that.path) || this.requiresRestart != that.requiresRestart && !this.requiresRestart.equals(that.requiresRestart) || this.requiresRoot != that.requiresRoot && !this.requiresRoot.equals(that.requiresRoot) || this.buildCount != that.buildCount && !this.buildCount.equals(that.buildCount) || this.builtWith != that.builtWith && !this.builtWith.equals(that.builtWith));
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getFilter() {
            return this.filter;
        }

        public void setFilter(String filter) {
            this.filter = filter;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
            this.versionUpdated = true;
        }

        public String getPath() {
            return this.path;
        }

        public Integer getBuildCount() {
            return this.buildCount;
        }

        public String getBuiltWith() {
            return this.builtWith;
        }

        public Date getCreated() {
            return this.created;
        }

        public Date getLastModified() {
            return this.lastModified;
        }

        public Date getLastUnpacked() {
            return this.lastUnpacked;
        }

        public String getLastUnpackedBy() {
            return this.lastUnpackedBy;
        }

        public Date getLastUnwrapped() {
            return this.lastUnwrapped;
        }

        public String getLastUnwrappedBy() {
            return this.lastUnwrappedBy;
        }

        public Date getLastWrapped() {
            return this.lastWrapped;
        }

        public String getLastWrappedBy() {
            return this.lastWrappedBy;
        }

        public Boolean getRequiresRestart() {
            return this.requiresRestart;
        }

        public Boolean getRequiresRoot() {
            return this.requiresRoot;
        }

        public String buildPath() {
            if (this.getName() == null || "".equals(this.getName())) {
                throw new NotImplementedException("Package name is not set.");
            }
            if (this.getGroup() == null || "".equals(this.getGroup())) {
                throw new NotImplementedException("Package group is not set.");
            }
            if (this.getVersion() == null || "".equals(this.getVersion())) {
                return String.format("/etc/packages/%s/%s.zip", this.getGroup(), this.getName());
            }
            return String.format("/etc/packages/%s/%s-%s.zip", this.getGroup(), this.getName(), this.getVersion());
        }

        public String update() throws ClientException {
            MultipartEntity mpe = new MultipartEntity();
            try {
                mpe.addPart(new FormBodyPart("path", (ContentBody)new StringBody(this.getPath())));
                mpe.addPart(new FormBodyPart("packageName", (ContentBody)new StringBody(this.getName())));
                mpe.addPart(new FormBodyPart("groupName", (ContentBody)new StringBody(this.getGroup())));
                if (this.getVersion() != null) {
                    mpe.addPart(new FormBodyPart("version", (ContentBody)new StringBody(this.getVersion())));
                }
                if (this.getDescription() != null) {
                    mpe.addPart(new FormBodyPart("description", (ContentBody)new StringBody(this.getDescription())));
                }
                if (this.getFilter() != null) {
                    mpe.addPart(new FormBodyPart("filter", (ContentBody)new StringBody(this.getFilter())));
                }
                mpe.addPart(new FormBodyPart("_charset_", (ContentBody)new StringBody("UTF-8")));
            }
            catch (Exception e) {
                throw new ClientException("Error while preparing HTTP request", e);
            }
            RequestExecutor exec = this.pm.http.doPost("/crx/packmgr/update.jsp", (HttpEntity)mpe, 200);
            if (this.versionUpdated) {
                this.path = this.buildPath();
                this.versionUpdated = false;
            }
            return exec.getContent();
        }

        public String build() throws ClientException {
            FormEntityBuilder feb = new FormEntityBuilder();
            feb.addParameter("cmd", "build");
            RequestExecutor exec = this.pm.http.doPost("/crx/packmgr/service/script.html" + this.getPath(), (HttpEntity)feb.getEntity(), 200);
            String content = exec.getContent();
            this.initAll(this.getPath());
            return content;
        }

        public String install() throws ClientException {
            FormEntityBuilder feb = new FormEntityBuilder();
            feb.addParameter("cmd", "install");
            feb.addParameter("autosave", "1024");
            feb.addParameter("recursive", "true");
            feb.addParameter("acHandling", "");
            RequestExecutor exec = this.pm.http.doPost("/crx/packmgr/service/script.html" + this.getPath(), (HttpEntity)feb.getEntity(), 200);
            String content = exec.getContent();
            this.initAll(this.getPath());
            return content;
        }

        public String replicate() throws ClientException {
            FormEntityBuilder feb = new FormEntityBuilder();
            feb.addParameter("cmd", "replicate");
            RequestExecutor exec = this.pm.http.doPost("/crx/packmgr/service/script.html" + this.getPath(), (HttpEntity)feb.getEntity(), 200);
            return exec.getContent();
        }

        public String testInstall() throws ClientException {
            FormEntityBuilder feb = new FormEntityBuilder();
            feb.addParameter("cmd", "dryrun");
            RequestExecutor exec = this.pm.http.doPost("/crx/packmgr/service/script.html" + this.getPath(), (HttpEntity)feb.getEntity(), 200);
            return exec.getContent();
        }

        public String unInstall() throws ClientException {
            FormEntityBuilder feb = new FormEntityBuilder();
            feb.addParameter("cmd", "uninstall");
            RequestExecutor exec = this.pm.http.doPost("/crx/packmgr/service/script.html" + this.getPath(), (HttpEntity)feb.getEntity(), 200);
            String content = exec.getContent();
            this.initAll(this.getPath());
            return content;
        }

        public String rewrap() throws ClientException {
            FormEntityBuilder feb = new FormEntityBuilder();
            feb.addParameter("cmd", "rewrap");
            RequestExecutor exec = this.pm.http.doPost("/crx/packmgr/service/script.html" + this.getPath(), (HttpEntity)feb.getEntity(), 200);
            String content = exec.getContent();
            this.initAll(this.getPath());
            return content;
        }

        public String getPackageContentsAsHtml() throws ClientException {
            FormEntityBuilder feb = new FormEntityBuilder();
            feb.addParameter("cmd", "contents");
            RequestExecutor exec = this.pm.http.doPost("/crx/packmgr/service/script.html" + this.getPath(), (HttpEntity)feb.getEntity(), 200);
            String content = exec.getContent();
            String statusMessage = content.replaceFirst("^.*\\(\\{\"success\":[^,]*,\"msg\":\"[^\"]*\"\\}\\).*$", "\\1");
            if (!statusMessage.contains("\"success\":true")) {
                throw new ClientException("The get contents request returned an error:\n" + statusMessage);
            }
            return content;
        }

        public String getPackageCoverageAsHtml() throws ClientException {
            FormEntityBuilder feb = new FormEntityBuilder();
            feb.addParameter("cmd", "preview");
            RequestExecutor exec = this.pm.http.doPost("/crx/packmgr/service/script.html" + this.getPath(), (HttpEntity)feb.getEntity(), 200);
            String content = exec.getContent();
            String statusMessage = content.replaceFirst("^.*\\(\\{\"success\":[^,]*,\"msg\":\"[^\"]*\"\\}\\).*$", "\\1");
            if (!statusMessage.contains("\"success\":true")) {
                throw new ClientException("The get coverage request returned an error:\n" + statusMessage);
            }
            return content;
        }

        public String delete() throws ClientException {
            FormEntityBuilder feb = new FormEntityBuilder();
            feb.addParameter("cmd", "delete");
            RequestExecutor exec = this.pm.http.doPost("/crx/packmgr/service/script.html" + this.getPath(), (HttpEntity)feb.getEntity(), 200);
            return exec.getContent();
        }

        private static String getJsonStringSafely(JsonNode node, String attr) {
            try {
                return node.get(attr).getValueAsText();
            }
            catch (Exception e) {
                return null;
            }
        }

        private static Date getJsonDateSafely(JsonNode node, String attr) {
            try {
                String dateAsString = node.get(attr).getTextValue();
                Date ret = new Date(Date.parse(dateAsString));
                return ret;
            }
            catch (Exception e) {
                return null;
            }
        }

        private static Integer getJsonIntegerSafely(JsonNode node, String attr) {
            try {
                return node.get(attr).getIntValue();
            }
            catch (Exception e) {
                return null;
            }
        }

        private static Boolean getJsonBooleanSafely(JsonNode node, String attr) {
            try {
                return node.get(attr).getBooleanValue();
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

