/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.testing.client;

import com.adobe.granite.testing.ClientException;
import com.adobe.granite.testing.GraniteTestBase;
import com.adobe.granite.testing.client.GraniteClient;
import com.adobe.granite.testing.util.FormEntityBuilder;
import com.adobe.granite.testing.util.HttpUtils;
import com.adobe.granite.testing.util.QuickstartOptions;
import com.adobe.granite.testing.util.SlingResponseHandler;
import org.apache.http.HttpEntity;
import org.apache.sling.testing.tools.http.RequestExecutor;

public class ReplicationClient
extends GraniteClient {
    public static final String AUTHOR_GROUP_PATH = "/etc/replication/agents.author";
    public static final String PUBLISH_REPLICATION_DEFAULT_AGENT = "/etc/replication/agents.author/publish";
    public static final String PUBLISH_REVERSE_REPLICATION_DEFAULT_AGENT = "/etc/replication/agents.author/publish_reverse";
    private static Boolean replicationAgentAdapted = false;
    private static Boolean reverseReplicationAgentAdapted = false;

    public ReplicationClient(String serverURL, String rootContext, String userName, String password) throws ClientException {
        super(serverURL, rootContext, userName, password);
        String serverUrlP = QuickstartOptions.getServerUrlPublish();
        String contextPathP = QuickstartOptions.getRootContextPublish();
        if (!replicationAgentAdapted.booleanValue()) {
            this.adaptReplicationAgent(PUBLISH_REPLICATION_DEFAULT_AGENT, serverUrlP, contextPathP, true);
            replicationAgentAdapted = true;
        }
        if (!reverseReplicationAgentAdapted.booleanValue()) {
            this.adaptReplicationAgent(PUBLISH_REVERSE_REPLICATION_DEFAULT_AGENT, serverUrlP, contextPathP, true);
            reverseReplicationAgentAdapted = true;
        }
    }

    public SlingResponseHandler activate(String nodePath, int ... expectedStatus) throws ClientException {
        RequestExecutor exec = this.http.doPost("/bin/replicate.json", (HttpEntity)new FormEntityBuilder().addParameter("cmd", "Activate").addParameter("_charset_", "utf-8").addParameter("path", nodePath).getEntity(), new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return HttpUtils.getSlingResponseHandler(exec);
    }

    public SlingResponseHandler deactivate(String pagePath, int ... expectedStatus) throws ClientException {
        RequestExecutor exec = this.http.doPost("/bin/replicate.json", (HttpEntity)new FormEntityBuilder().addParameter("cmd", "Deactivate").addParameter("_charset_", "utf-8").addParameter("path", pagePath).getEntity(), new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return HttpUtils.getSlingResponseHandler(exec);
    }

    public String adaptReplicationAgent(String agentPath, String baseUrl, String rootContextPath, boolean sudo) throws ClientException {
        if ("".equals(agentPath) || agentPath == null) {
            throw new IllegalArgumentException("Path to ReplicationAgent may not be null.");
        }
        String transportUri = baseUrl + rootContextPath + "/bin/receive?sling:authRequestLogin=1";
        if (this.exists(agentPath)) {
            if (sudo) {
                GraniteClient cAdmin = new GraniteClient(this.getServerUrl(), this.getRootContext(), GraniteTestBase.getAdminUser(), GraniteTestBase.getAdminPassword());
                cAdmin.setPropertyString(agentPath + "/jcr:content", "transportUri", transportUri, new int[0]);
            } else {
                this.setPropertyString(agentPath + "/jcr:content", "transportUri", transportUri, new int[0]);
            }
            transportUri = this.getJsonNode(agentPath, 1).path("jcr:content").get("transportUri").getValueAsText();
            System.out.println("Replication Agent '" + agentPath + "' adapted! Property 'transportUri' points to: " + transportUri);
        }
        return transportUri;
    }
}

