/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.testing.client;

import com.adobe.granite.testing.ClientException;
import com.adobe.granite.testing.client.GraniteClient;
import com.adobe.granite.testing.client.security.Authorizable;
import com.adobe.granite.testing.client.security.AuthorizableManager;
import com.adobe.granite.testing.client.security.Group;
import com.adobe.granite.testing.client.security.User;
import com.adobe.granite.testing.util.FormEntityBuilder;
import com.adobe.granite.testing.util.HttpUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityClient
extends GraniteClient {
    public static final String LOGIN_URL = "/libs/granite/core/content/login.html";
    public static final String ADMIN_URL = "/libs/granite/security/content/admin.html";
    private AuthorizableManager authorizableMgr = new AuthorizableManager(this);

    public SecurityClient(String serverURL, String rootContext, String userName, String password) {
        super(serverURL, rootContext, userName, password);
    }

    public String getLoginUrl() {
        return LOGIN_URL;
    }

    public String getAdminUrl() {
        return ADMIN_URL;
    }

    public AuthorizableManager getManager() {
        return this.authorizableMgr;
    }

    public void deleteAuthorizables(Authorizable[] authorizables, int ... expectedStatus) throws ClientException {
        if (authorizables == null) {
            return;
        }
        for (Authorizable authorizable : authorizables) {
            authorizable.delete(expectedStatus);
        }
    }

    public User createUser(String userId, int ... expectedStatus) throws ClientException {
        return this.createUser(userId, userId, null, null, null, expectedStatus);
    }

    public User createUser(String userId, String intermediatePath, int ... expectedStatus) throws ClientException {
        return this.createUser(userId, userId, intermediatePath, null, null, expectedStatus);
    }

    public <T extends Group> User createUser(String userId, String password, T[] assignedGroups, int ... expectedStatus) throws ClientException {
        HashMap profileMap = new HashMap();
        return this.createUser(userId, password, null, null, (Group[])assignedGroups, expectedStatus);
    }

    public <T extends Group> User createUser(String userId, String password, String intermediatePath, Map<String, String> profileMap, T[] assignedGroups, int ... expectedStatus) throws ClientException {
        User user = User.createUser(this, userId, password, intermediatePath, profileMap, expectedStatus);
        if (assignedGroups != null) {
            for (T assignedGroup : assignedGroups) {
                ((Group)assignedGroup).addMembers(new Authorizable[]{user}, 200);
            }
        }
        return user;
    }

    public Group createGroup(String groupId, int ... expectedStatus) throws ClientException {
        return this.createGroup(groupId, null, null, null, null, expectedStatus);
    }

    public Group createGroup(String groupId, String intermediatePath, int ... expectedStatus) throws ClientException {
        return this.createGroup(groupId, intermediatePath, groupId, null, null, expectedStatus);
    }

    public Group createGroup(String groupId, Group[] assignedGroups, int ... expectedStatus) throws ClientException {
        return this.createGroup(groupId, null, null, null, assignedGroups, expectedStatus);
    }

    public Group createGroup(String groupId, String intermediatePath, String givenName, String aboutMe, Group[] assignedGroups, int ... expectedStatus) throws ClientException {
        Group group = Group.createGroup(this, groupId, intermediatePath, givenName, aboutMe, expectedStatus);
        if (assignedGroups != null) {
            group.addMembers(assignedGroups, 200);
        }
        return group;
    }

    public String getLoginTokenCookie(int ... expectedStatus) throws ClientException {
        String postPath = this.getLoginUrl() + "/j_security_check";
        FormEntityBuilder feb = new FormEntityBuilder().addParameter("j_username", this.getUser()).addParameter("j_password", this.getPassword()).addParameter("resource", "/").addParameter("_charset_", "utf-8").addParameter("contextPath", "");
        String[] headers = new String[]{"Content-Type", "application/x-www-form-urlencoded", "Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8"};
        Object exec = this.http.doPost(postPath, (HttpEntity)feb.getEntity(), headers, false, false, new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(302, expectedStatus));
        HttpResponse response = exec.getResponse();
        String cookie = response.getHeaders("Set-Cookie")[0].getValue();
        cookie = cookie.substring(0, cookie.indexOf(";"));
        return cookie;
    }
}

