/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.testing.client;

import com.adobe.granite.testing.ClientException;
import com.adobe.granite.testing.client.GraniteClient;
import com.adobe.granite.testing.client.workflow.InboxItem;
import com.adobe.granite.testing.client.workflow.WorkItem;
import com.adobe.granite.testing.client.workflow.WorkflowEngine;
import com.adobe.granite.testing.client.workflow.WorkflowInstance;
import com.adobe.granite.testing.client.workflow.WorkflowModel;
import com.adobe.granite.testing.util.FormEntityBuilder;
import com.adobe.granite.testing.util.HttpUtils;
import com.adobe.granite.testing.util.JsonUtils;
import com.adobe.granite.testing.util.ResourceUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.sling.testing.tools.http.RequestExecutor;
import org.codehaus.jackson.JsonNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowClient
extends GraniteClient {
    public static final String MANAGE_WF_INSTANCES_PATH = "/etc/workflow/instances";
    public static final String MANAGE_WF_MODELS_PATH = "/etc/workflow/models";
    public static final String MANAGE_WF_INBOX_PATH = "/bin/workflow/inbox";
    public static final String MANAGE_WF_ENGINE_PATH = "/etc/workflow";
    public static final String MODEL_LIST_TYPE_ID = "id";
    public static final String MODEL_LIST_TYPE_URI = "uri";
    public static final String MODEL_DESCR_TYPE_JSON = "JSON";
    public static final String PAYLOAD_TYPE_JCR = "JCR_PATH";
    public static final String PAYLOAD_TYPE_URL = "URL";

    public WorkflowClient(String serverURL, String rootContext, String userName, String password) {
        super(serverURL, rootContext, userName, password);
    }

    public String deployModel(String modelSourcePath, String modelType, int ... expectedStatus) throws ClientException, IOException {
        if (modelType == null) {
            modelType = MODEL_DESCR_TYPE_JSON;
        }
        String model = ResourceUtil.readResourceAsString(modelSourcePath);
        RequestExecutor exec = this.http.doPost(MANAGE_WF_MODELS_PATH, (HttpEntity)new FormEntityBuilder().addParameter("model", model).addParameter("type", modelType).getEntity(), new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(201, expectedStatus));
        if (exec.getResponse().getStatusLine().getStatusCode() == 201) {
            String url = exec.getResponse().getHeaders("Location")[0].getValue();
            String path = this.getPathFromURL(url);
            if (path == null) {
                throw new ClientException("Couldn't extract Model ID (Handle) from returned Location Header!");
            }
            path = path.substring(this.getRootContext().length());
            return path;
        }
        return null;
    }

    public RequestExecutor advanceWorkItem(String workItemId, String routeId, int ... expectedStatus) throws ClientException {
        RequestExecutor exec = this.http.doPost(MANAGE_WF_INBOX_PATH, (HttpEntity)new FormEntityBuilder().addParameter("item", workItemId).addParameter("route", routeId).getEntity(), new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return exec;
    }

    public RequestExecutor stepBackWorkItem(String workItemId, String backrouteId, int ... expectedStatus) throws ClientException {
        RequestExecutor exec = this.http.doPost(MANAGE_WF_INBOX_PATH, (HttpEntity)new FormEntityBuilder().addParameter("item", workItemId).addParameter("backroute", backrouteId).getEntity(), new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return exec;
    }

    public RequestExecutor delegateWorkItem(String workItemId, String delegatee, int ... expectedStatus) throws ClientException {
        RequestExecutor exec = this.http.doPost(MANAGE_WF_INBOX_PATH, (HttpEntity)new FormEntityBuilder().addParameter("item", workItemId).addParameter("delegatee", delegatee).getEntity(), new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return exec;
    }

    public RequestExecutor approveAndAdvanceWorkItem(WorkItem workItem, String routeId, int ... expectedStatus) throws ClientException {
        RequestExecutor exec = this.http.doPost(workItem.getPayLoad(), (HttpEntity)new FormEntityBuilder().addParameter("item", workItem.getId()).addParameter("route", routeId).addParameter("./approved", "true").addParameter("./approved@Delete", "true").addParameter("./approved@TypeHint", "Boolean").getEntity(), new int[0]);
        exec = this.http.doPost(MANAGE_WF_INBOX_PATH, (HttpEntity)new FormEntityBuilder().addParameter("item", workItem.getId()).addParameter("route", routeId).addParameter("./approved", "true").addParameter("./approved@Delete", "true").addParameter("./approved@TypeHint", "Boolean").getEntity(), new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return exec;
    }

    public RequestExecutor approveComment(String workItemId, String routeId, int ... expectedStatus) throws ClientException {
        RequestExecutor exec = this.http.doPost(MANAGE_WF_INBOX_PATH, (HttpEntity)new FormEntityBuilder().addParameter("item", workItemId).addParameter("route", routeId).addParameter("./approved", "true").addParameter("./approved@Delete", "true").addParameter("./approved@TypeHint", "Boolean").getEntity(), new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return exec;
    }

    public Map<String, InboxItem> getInboxItems(int ... expectedStatus) throws ClientException {
        RequestExecutor exec = this.http.doGet("/bin/workflow/inbox.json", new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        JsonNode workItems = JsonUtils.getJsonNodeFromString(exec.getContent());
        HashMap<String, InboxItem> map = new HashMap<String, InboxItem>();
        for (int i = 0; i < workItems.size(); ++i) {
            JsonNode workItem = workItems.get(i);
            map.put(workItem.get(MODEL_LIST_TYPE_URI).getValueAsText(), new InboxItem(workItem));
        }
        return map;
    }

    public WorkItem getWorkItemByURI(String uri, int ... expectedStatus) throws ClientException {
        RequestExecutor exec = this.http.doGet(uri + ".json", new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return new WorkItem(JsonUtils.getJsonNodeFromString(exec.getContent()));
    }

    public List<String> getWorkItemBackRouteIds(String uri, int ... expectedStatus) throws ClientException {
        RequestExecutor exec = this.http.doGet(uri + ".backroutes.json", new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        JsonNode rootNode = JsonUtils.getJsonNodeFromString(exec.getContent()).get("backroutes");
        ArrayList<String> backrouteIds = new ArrayList<String>();
        for (int i = 0; i < rootNode.size(); ++i) {
            backrouteIds.add(rootNode.get(i).get("rid").getValueAsText());
        }
        return backrouteIds;
    }

    public RequestExecutor deleteModel(String modelId, int ... expectedStatus) throws ClientException {
        String url = this.getRootContext() + modelId + ".json";
        Object exec = this.http.doPost(url, null, new String[]{"X-HTTP-Method-Override", "DELETE"}, false, false, new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(204, expectedStatus));
        return exec;
    }

    public RequestExecutor updateModel(String modelSourcePath, String modelType, String modelId, int ... expectedStatus) throws ClientException, IOException {
        if (modelType == null) {
            modelType = MODEL_DESCR_TYPE_JSON;
        }
        String model = ResourceUtil.readResourceAsString(modelSourcePath);
        RequestExecutor exec = this.http.doPost(modelId, (HttpEntity)new FormEntityBuilder().addParameter("model", model).addParameter("type", modelType).getEntity(), new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return exec;
    }

    public WorkflowEngine getWorkflowEngineInfo(int ... expectedStatus) throws ClientException {
        RequestExecutor exec = this.http.doGet("/etc/workflow.json", expectedStatus);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        JsonNode rootNode = JsonUtils.getJsonNodeFromString(exec.getContent());
        HashMap<String, String> properties = new HashMap<String, String>();
        rootNode.getFieldNames();
        Iterator it = rootNode.getFieldNames();
        while (it.hasNext()) {
            String propName = (String)it.next();
            properties.put(propName, rootNode.get(propName).getValueAsText());
        }
        return new WorkflowEngine(properties);
    }

    public RequestExecutor stopWorkflowEngine(int ... expectedStatus) throws ClientException {
        RequestExecutor exec = this.http.doPost(MANAGE_WF_ENGINE_PATH, (HttpEntity)new FormEntityBuilder().addParameter("state", "DISABLED").getEntity(), new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return exec;
    }

    public RequestExecutor startWorkflowEngine(int ... expectedStatus) throws ClientException {
        RequestExecutor exec = this.http.doPost(MANAGE_WF_ENGINE_PATH, (HttpEntity)new FormEntityBuilder().addParameter("state", "ACTIVE").getEntity(), new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return exec;
    }

    public boolean isWorkflowEngineActive() throws ClientException {
        return this.getWorkflowEngineInfo(new int[0]).getProperty("state").toLowerCase().equals("active");
    }

    public String startWorkflow(String modelId, String payload, int ... expectedStatus) throws ClientException {
        return this.startWorkflow(modelId, PAYLOAD_TYPE_JCR, payload, null, null, null, expectedStatus);
    }

    public String startWorkflow(String modelId, String payloadType, String payload, Map<String, String> metaData, String title, String comment, int ... expectedStatus) throws ClientException {
        if (modelId == null || modelId.equals("")) {
            throw new ClientException("Invalid ModelId!");
        }
        if (payload == null || payload.equals("")) {
            throw new ClientException("No payload set!");
        }
        if (payloadType == null) {
            payloadType = PAYLOAD_TYPE_JCR;
        }
        FormEntityBuilder form = new FormEntityBuilder();
        form.addParameter("model", modelId);
        form.addParameter("payloadType", payloadType);
        form.addParameter("payload", payload);
        if (title != null && !title.equals("")) {
            form.addParameter("workflowTitle", title);
        }
        if (comment != null && !comment.equals("")) {
            form.addParameter("startComment", comment);
        }
        if (metaData != null) {
            for (String key : metaData.keySet()) {
                form.addParameter(key, metaData.get(key));
            }
        }
        RequestExecutor exec = this.http.doPost(MANAGE_WF_INSTANCES_PATH, (HttpEntity)form.getEntity(), new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(201, expectedStatus));
        if (exec.getResponse().getStatusLine().getStatusCode() == 201) {
            return this.getPathFromURL(HttpUtils.getSlingResponseHandler(exec).getLocation());
        }
        return null;
    }

    public RequestExecutor updateWfInstanceComment(String instanceURI, String comment, int ... expectedStatus) throws ClientException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("startComment", comment);
        return this.updateWfInstanceMetaData(instanceURI, map, expectedStatus);
    }

    public RequestExecutor updateWfInstanceTitle(String instanceURI, String title, int ... expectedStatus) throws ClientException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("workflowTitle", title);
        return this.updateWfInstanceMetaData(instanceURI, map, expectedStatus);
    }

    public RequestExecutor updateWfInstanceMetaData(String instanceURI, Map<String, String> metaData, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = new FormEntityBuilder();
        form.addParameter("action", "UPDATE");
        for (String key : metaData.keySet()) {
            form.addParameter(key, metaData.get(key));
        }
        RequestExecutor exec = this.http.doPost(instanceURI, (HttpEntity)form.getEntity(), new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return exec;
    }

    public ArrayList<String> getWorkflowInstanceURLs(Status wfStatus, int ... expectedStatus) throws ClientException {
        String status = "";
        if (wfStatus != null) {
            status = "." + wfStatus.getString();
        }
        RequestExecutor exec = this.http.doGet(MANAGE_WF_INSTANCES_PATH + status + ".json", new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        JsonNode rootNode = JsonUtils.getJsonNodeFromString(exec.getContent());
        ArrayList<String> wfInstances = new ArrayList<String>();
        for (JsonNode aRootNode : rootNode) {
            wfInstances.add(aRootNode.get(MODEL_LIST_TYPE_URI).getValueAsText());
        }
        return wfInstances;
    }

    public ArrayList<String> getWorkflowModels(String listType, int ... expectedStatus) throws ClientException {
        if (listType == null) {
            listType = MODEL_LIST_TYPE_URI;
        }
        RequestExecutor exec = this.http.doGet("/etc/workflow/models.json", new String[]{"format", listType}, expectedStatus);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        JsonNode rootNode = JsonUtils.getJsonNodeFromString(exec.getContent());
        ArrayList<String> wfModels = new ArrayList<String>();
        String nodeProperty = MODEL_LIST_TYPE_URI;
        if (listType.equals(MODEL_LIST_TYPE_ID)) {
            nodeProperty = "value";
        }
        for (JsonNode aRootNode : rootNode) {
            wfModels.add(aRootNode.get(nodeProperty).getValueAsText());
        }
        return wfModels;
    }

    public String getWorkflowModelAsJSON(String modelId, String version, int ... expectedStatus) throws ClientException {
        if (version == null || version.equals("HEAD")) {
            version = "";
        } else {
            Pattern p = Pattern.compile("^\\d+\\.\\d+$");
            Matcher m = p.matcher(version);
            if (!m.find()) {
                throw new IllegalArgumentException("Version identifier " + version + " is invalid!");
            }
            version = "." + version;
        }
        String uri = this.getRootContext() + modelId + version + ".json";
        RequestExecutor exec = this.http.doGet(uri, new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return exec.getContent();
    }

    public WorkflowModel getWorkflowModel(String modelId, String version, int ... expectedStatus) throws ClientException {
        return new WorkflowModel(JsonUtils.getJsonNodeFromString(this.getWorkflowModelAsJSON(modelId, version, expectedStatus)));
    }

    public WorkflowInstance getWorkflowInstance(String instanceURI, int ... expectedStatus) throws ClientException {
        RequestExecutor exec = this.http.doGet(instanceURI + ".json", new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return new WorkflowInstance(JsonUtils.getJsonNodeFromString(exec.getContent()));
    }

    public RequestExecutor setWorkflowInstanceStatus(String instanceURI, Status status, int ... expectedStatus) throws ClientException {
        RequestExecutor exec = this.http.doPost(instanceURI, (HttpEntity)new FormEntityBuilder().addParameter("state", status.getString()).getEntity(), new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return exec;
    }

    private String getPathFromURL(String url) {
        if (url.startsWith("http://")) {
            url = url.substring("http://".length());
        }
        url = url.substring(url.indexOf("/"));
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseJSONDate(String date) {
        Locale store = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        try {
            Date date2 = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy").parse(date);
            return date2;
        }
        catch (ParseException e) {
            Date date3 = null;
            return date3;
        }
        finally {
            Locale.setDefault(store);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        RUNNING("RUNNING"),
        SUSPENDED("SUSPENDED"),
        ABORTED("ABORTED"),
        COMPLETED("COMPLETED");

        private String status;

        private Status(String status) {
            this.status = status;
        }

        public String getString() {
            return this.status;
        }
    }
}

