/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.testing.client.security;

import com.adobe.granite.testing.ClientException;
import com.adobe.granite.testing.assertion.GraniteAssert;
import com.adobe.granite.testing.client.SecurityClient;
import com.adobe.granite.testing.client.security.Authorizable;
import com.adobe.granite.testing.client.security.Group;
import com.adobe.granite.testing.client.security.User;
import com.adobe.granite.testing.util.FormEntityBuilder;
import com.adobe.granite.testing.util.HttpUtils;
import com.adobe.granite.testing.util.JsonUtils;
import com.adobe.granite.testing.util.SlingResponseHandler;
import com.adobe.granite.testing.util.URLParameterBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.http.HttpEntity;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.testing.tools.http.RequestExecutor;
import org.codehaus.jackson.JsonNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthorizable
implements Authorizable {
    protected SecurityClient client;
    protected String authorizableId;
    protected String authorizablePath;
    private String authorizableUrl;

    public <T extends SecurityClient> AbstractAuthorizable(T client, String authorizableId) throws ClientException {
        this(client, authorizableId, null);
    }

    public <T extends SecurityClient> AbstractAuthorizable(T client, String authorizableId, String authorizablePath) throws ClientException {
        if (client == null || authorizableId == null) {
            throw new IllegalArgumentException("One of the following parameters may not be null: client / authorizableId!");
        }
        this.client = client;
        this.authorizableId = authorizableId;
        this.authorizablePath = authorizablePath;
        if (authorizablePath == null) {
            this.authorizablePath = AbstractAuthorizable.buildAuthorizablePath(authorizableId, this.getRootPath(), null);
        }
        this.authorizableUrl = AbstractAuthorizable.encodePathToURL(this.authorizablePath);
        if (!client.exists(this.authorizableUrl)) {
            throw new IllegalArgumentException("Authorizable in path '" + this.authorizablePath + "' does not exist!");
        }
    }

    @Override
    public SecurityClient getClient() {
        return this.client;
    }

    @Override
    public String getId() {
        return this.authorizableId;
    }

    @Override
    public String getHomePath() {
        return this.authorizablePath;
    }

    @Override
    public String getHomeUrl() {
        return this.authorizableUrl;
    }

    @Override
    public String getJsonAsString(String propsFilter, int ... expectedStatus) throws ClientException {
        URLParameterBuilder params = new URLParameterBuilder();
        params.add("props", propsFilter != null ? propsFilter : "*");
        return this.doGet(params, expectedStatus).getContent();
    }

    @Override
    public String getUserPropertiesJsonAsString(int ... expectedStatus) throws ClientException {
        return this.client.http.doGet(this.getHomePath() + ".userproperties" + ".json", expectedStatus).getContent();
    }

    @Override
    public boolean exists() throws ClientException {
        return this.client.exists(this.getHomePath());
    }

    @Override
    public SlingResponseHandler delete(int ... expectedStatus) throws ClientException {
        FormEntityBuilder formEntry = new FormEntityBuilder();
        formEntry.addParameter("_charset_", "utf-8");
        formEntry.addParameter("deleteAuthorizable", "1");
        return HttpUtils.getSlingResponseHandler(this.doPost(formEntry, expectedStatus));
    }

    @Override
    public <T extends SecurityClient> Authorizable create(T client, Class<? extends AbstractAuthorizable> authorizableClass, String authorizableId, FormEntityBuilder formParameters, int ... expectedStatus) throws ClientException {
        return client.getManager().create(client, authorizableClass, authorizableId, formParameters, expectedStatus);
    }

    @Override
    public Map<String, Authorizable> getMemberOf() throws ClientException {
        JsonNode authorizableNode = JsonUtils.getJsonNodeFromString(this.getJsonAsString("memberOf", 200));
        JsonNode propsNode = null;
        if (authorizableNode != null) {
            propsNode = authorizableNode.get("memberOf");
        }
        return this.buildAuthorizableList(propsNode);
    }

    @Override
    public Map<String, Authorizable> getMembers() throws ClientException {
        JsonNode authorizableNode = JsonUtils.getJsonNodeFromString(this.getJsonAsString("members", 200));
        JsonNode propsNode = null;
        if (authorizableNode != null) {
            propsNode = authorizableNode.get("members");
        }
        return this.buildAuthorizableList(propsNode);
    }

    @Override
    public Map<String, Authorizable> getImpersonators() throws ClientException {
        JsonNode authorizableNode = JsonUtils.getJsonNodeFromString(this.getJsonAsString("impersonators", 200));
        JsonNode propsNode = null;
        if (authorizableNode != null) {
            propsNode = authorizableNode.get("impersonators");
        }
        return this.buildAuthorizableList(propsNode);
    }

    @Override
    public boolean isImpersonated() throws ClientException {
        JsonNode authorizableNode = JsonUtils.getJsonNodeFromString(this.getJsonAsString(null, 200));
        JsonNode isImpersonated = authorizableNode.get("isImpersonated");
        return isImpersonated != null && "true".equals(isImpersonated.getValueAsText());
    }

    @Override
    public JsonNode getProfile() throws ClientException {
        JsonNode authorizableNode = JsonUtils.getJsonNodeFromString(this.getJsonAsString("profile/*", new int[0]));
        JsonNode propsNode = null;
        if (authorizableNode != null) {
            propsNode = authorizableNode.get("profile");
        }
        return propsNode;
    }

    public RequestExecutor doPost(FormEntityBuilder formParameters, int ... expectedStatus) throws ClientException {
        String homeURL = this.getHomeUrl();
        return this.client.http.doPost(homeURL + ".rw" + ".html", (HttpEntity)formParameters.getEntity(), expectedStatus);
    }

    public RequestExecutor doGet(URLParameterBuilder formParameters, int ... expectedStatus) throws ClientException {
        return this.client.http.doGet(this.getHomeUrl() + ".rw" + ".json", formParameters, expectedStatus);
    }

    public static Class<? extends AbstractAuthorizable> getAuthorizableClass(String authorizableType) {
        return "user".equals(authorizableType) ? User.class : Group.class;
    }

    public static String getType(String authorizableHome) {
        return authorizableHome.contains("/home/users") ? "user" : "group";
    }

    public static String buildAuthorizablePath(String authorizableId, String rootPath, String intermediatePath) throws ClientException {
        boolean buildDefaultPath = intermediatePath == null || "".equals(intermediatePath);
        String authorizablePath = "";
        if (buildDefaultPath) {
            authorizablePath = rootPath;
            authorizablePath = authorizablePath + "/";
            authorizablePath = authorizablePath + Text.escapeIllegalJcrChars((String)authorizableId.substring(0, 1));
        } else {
            authorizablePath = intermediatePath;
        }
        authorizablePath = authorizablePath + "/" + Text.escapeIllegalJcrChars((String)authorizableId);
        return authorizablePath;
    }

    protected static String encodePathToURL(String authorizableHomePath) throws ClientException {
        String authorizableUrl = "";
        try {
            StringTokenizer st = new StringTokenizer(authorizableHomePath, "/");
            while (st.hasMoreElements()) {
                String nn = (String)st.nextElement();
                authorizableUrl = authorizableUrl + "/" + URLEncoder.encode(nn, "UTF-8").replaceAll("\\+", "%20");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException("Error occured while URL encoding the path to authorizable!", e);
        }
        return authorizableUrl;
    }

    protected static String encodeURI(String unescapedPath) throws ClientException {
        String escapedPath = "";
        try {
            escapedPath = URIUtil.encodePath((String)unescapedPath);
        }
        catch (URIException e) {
            throw new ClientException("Could not encode URI: " + unescapedPath);
        }
        return escapedPath;
    }

    protected Map<String, Authorizable> buildAuthorizableList(JsonNode authorizableJsonNode) throws ClientException {
        if (authorizableJsonNode == null) {
            throw new IllegalArgumentException("JSON of authorizable may not be null!");
        }
        LinkedHashMap<String, Authorizable> authorizables = new LinkedHashMap<String, Authorizable>();
        if (authorizableJsonNode.isArray()) {
            for (int i = 0; i < authorizableJsonNode.size(); ++i) {
                Authorizable authorizable = this.buildAuthorizable(authorizableJsonNode.get(i));
                authorizables.put(authorizable.getHomePath(), authorizable);
            }
        } else {
            Authorizable authorizable = this.buildAuthorizable(authorizableJsonNode);
            authorizables.put(authorizable.getHomePath(), authorizable);
        }
        return authorizables;
    }

    private Authorizable buildAuthorizable(JsonNode authorizableNode) throws ClientException {
        GraniteAssert.assertSchemaValid(authorizableNode.toString(), "/schemas/json/authorizable-schema.json");
        String authorizableId = authorizableNode.get("authorizableId").getValueAsText();
        String authorizableHome = authorizableNode.get("home").getValueAsText();
        String authorizableType = AbstractAuthorizable.getType(authorizableHome);
        return this.client.getManager().getAuthorizable(AbstractAuthorizable.getAuthorizableClass(authorizableType), authorizableId, authorizableHome);
    }
}

