/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.testing.client.security;

import com.adobe.granite.testing.ClientException;
import com.adobe.granite.testing.client.security.AbstractAuthorizable;
import com.adobe.granite.testing.client.security.Profile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.codehaus.jackson.JsonNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractProfile
implements Profile {
    public static final String NODE_PROFILE = "profile";
    protected AbstractAuthorizable authorizable;
    protected LinkedHashMap<String, String> profileProps = new LinkedHashMap();

    public <T extends AbstractAuthorizable> AbstractProfile(T authorizable) throws ClientException {
        if (authorizable == null) {
            throw new IllegalArgumentException("Authorizable has to exist and therefore may not be null!");
        }
        this.authorizable = authorizable;
        this.loadProperties();
    }

    public JsonNode getProfileNode() throws ClientException {
        return this.authorizable.getProfile();
    }

    @Override
    public HashMap<String, String> getProperties() {
        return this.profileProps;
    }

    @Override
    public void setProperties(HashMap<String, String> propertiesMap) {
        if (propertiesMap == null) {
            throw new IllegalArgumentException("Properties map for profile may not be empty!");
        }
        this.profileProps.putAll(propertiesMap);
    }

    private void loadProperties() throws ClientException {
        JsonNode profileNode = this.getProfileNode();
        if (profileNode != null) {
            Iterator fieldNames = profileNode.getFieldNames();
            while (fieldNames.hasNext()) {
                String fieldName = (String)fieldNames.next();
                this.profileProps.put(fieldName, profileNode.get(fieldName).getTextValue());
            }
        }
    }
}

