/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.testing.client.security;

import com.adobe.granite.testing.ClientException;
import com.adobe.granite.testing.GraniteTestBase;
import com.adobe.granite.testing.assertion.GraniteAssert;
import com.adobe.granite.testing.client.SecurityClient;
import com.adobe.granite.testing.client.security.AbstractAuthorizable;
import com.adobe.granite.testing.client.security.Authorizable;
import com.adobe.granite.testing.client.security.Group;
import com.adobe.granite.testing.client.security.User;
import com.adobe.granite.testing.util.FormEntityBuilder;
import com.adobe.granite.testing.util.HttpUtils;
import com.adobe.granite.testing.util.JsonUtils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.sling.testing.tools.http.RequestExecutor;
import org.codehaus.jackson.JsonNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizableManager {
    public static final String AUTHORIZABLE_POST_PATH = "/libs/granite/security/post/authorizables";
    public static final String AUTHORIZABLES_PATH = "/libs/granite/security/search/authorizables";
    public static final String AUTHORIZABLES = "authorizables";
    public static final String GROUP_EVERYONE = "/home/groups/e/everyone";
    public static final String GROUP_ADMINISTRATORS = "/home/groups/a/administrators";
    public static final String GROUP_USER_ADMINISTRATORS = "/home/groups/u/user-administrators";
    public static final String GROUP_CONTRIBUTOR = "/home/groups/c/contributor";
    public static final String USER_ADMIN = "/home/users/a/admin";
    protected SecurityClient client;

    public <T extends SecurityClient> AuthorizableManager(T client) {
        this.client = client;
    }

    public Group getGroupAdministrators() throws ClientException {
        return this.getGroup("administrators", GROUP_ADMINISTRATORS);
    }

    public Group getGroupContributor() throws ClientException {
        return this.getGroup("contributor", GROUP_CONTRIBUTOR);
    }

    public Group getGroupEveryone() throws ClientException {
        return this.getGroup("everyone", GROUP_EVERYONE);
    }

    public Group getGroupUserAdministrators() throws ClientException {
        return this.getGroup("user-administrators", GROUP_USER_ADMINISTRATORS);
    }

    public User getUserAdmin() throws ClientException {
        return this.getUser(GraniteTestBase.getAdminUser());
    }

    public User getUser(String userId, String userPath) throws ClientException {
        return this.getAuthorizable(User.class, userId, userPath);
    }

    public User getUser(String userId) throws ClientException {
        return this.getUser(userId, null);
    }

    public Group getGroup(String groupId, String groupPath) throws ClientException {
        return this.getAuthorizable(Group.class, groupId, groupPath);
    }

    public Group getGroup(String groupId) throws ClientException {
        return this.getGroup(groupId, null);
    }

    public <T extends SecurityClient> Authorizable create(T client, Class<? extends AbstractAuthorizable> authorizableClass, String authorizableId, FormEntityBuilder formParameters, int ... expectedStatus) throws ClientException {
        if (formParameters == null) {
            throw new IllegalArgumentException("Parameters for creating an authorizable may not be null!");
        }
        RequestExecutor exec = client.http.doPost(AUTHORIZABLES_PATH, (HttpEntity)formParameters.getEntity(), new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(201, expectedStatus));
        return this.getAuthorizable(authorizableClass, authorizableId);
    }

    protected <T extends AbstractAuthorizable> T getAuthorizable(Class<T> authorizableClass, String authorizableId, String authorizablePath) throws ClientException {
        AbstractAuthorizable authorizable;
        try {
            Constructor<T> cons = authorizableClass.getConstructor(SecurityClient.class, String.class, String.class);
            authorizable = (AbstractAuthorizable)cons.newInstance(this.client, authorizableId, authorizablePath);
        }
        catch (Exception e) {
            throw new ClientException("Could not initialize Authorizable: '" + authorizableClass.getCanonicalName() + "'.", e);
        }
        return (T)authorizable;
    }

    protected <T extends AbstractAuthorizable> T getAuthorizable(Class<T> authorizableClass, String authorizableId) throws ClientException {
        return this.getAuthorizable(authorizableClass, authorizableId, null);
    }

    public List<Authorizable> getAuthorizables(String query) throws ClientException {
        JsonNode json = JsonUtils.getJsonNodeFromString(this.getAuthorizablesJson(query));
        JsonNode authorizablesNode = json.get(AUTHORIZABLES);
        ArrayList<Authorizable> authorizables = new ArrayList<Authorizable>();
        if (authorizablesNode.isArray()) {
            for (JsonNode authorizableNode : authorizablesNode) {
                GraniteAssert.assertSchemaValid(authorizableNode.toString(), "/schemas/json/authorizable-schema.json");
                String authorizableId = authorizableNode.get("authorizableId").getValueAsText();
                String authorizableHome = authorizableNode.get("home").getValueAsText();
                String type = authorizableNode.get("type").getValueAsText();
                AbstractAuthorizable authorizable = this.getAuthorizable(AbstractAuthorizable.getAuthorizableClass(type), authorizableId, authorizableHome);
                authorizables.add(authorizable);
            }
        }
        return authorizables;
    }

    public String getAuthorizablesJson(String query) throws ClientException {
        RequestExecutor exec = this.client.http.doGet("/libs/granite/security/search/authorizables.json?&offset=0&max=-1&query=%7B" + (query == null ? "" : query) + "%7D", 200);
        return exec.getContent();
    }

    public RequestExecutor doPost(FormEntityBuilder formParameters, int ... expectedStatus) throws ClientException {
        return this.client.http.doPost("/libs/granite/security/post/authorizables.html", (HttpEntity)formParameters.getEntity(), expectedStatus);
    }
}

