/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.testing.client.security;

import com.adobe.granite.testing.ClientException;
import com.adobe.granite.testing.client.SecurityClient;
import com.adobe.granite.testing.client.security.AbstractAuthorizable;
import com.adobe.granite.testing.client.security.Authorizable;
import com.adobe.granite.testing.client.security.GroupProfile;
import com.adobe.granite.testing.util.FormEntityBuilder;
import com.adobe.granite.testing.util.HttpUtils;
import com.adobe.granite.testing.util.SlingResponseHandler;
import org.apache.sling.testing.tools.http.RequestExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
extends AbstractAuthorizable {
    public static final String ROOT_PATH = "/home/groups";
    protected GroupProfile profile;

    public <T extends SecurityClient> Group(T client, String authorizableId) throws ClientException {
        super(client, authorizableId);
    }

    public <T extends SecurityClient> Group(T client, String authorizableId, String authorizablePath) throws ClientException {
        super(client, authorizableId, authorizablePath);
    }

    @Override
    public String getRootPath() {
        return ROOT_PATH;
    }

    public GroupProfile getGroupProfile() throws ClientException {
        if (this.profile == null) {
            this.initProfile();
        }
        return this.profile;
    }

    protected <T extends SecurityClient> void initProfile() throws ClientException {
        this.profile = new GroupProfile(this);
    }

    public SlingResponseHandler addMembers(Authorizable[] authorizables, int ... expectedStatus) throws ClientException {
        if (authorizables == null) {
            throw new IllegalArgumentException("List of authorizables may not be null!");
        }
        FormEntityBuilder formEntry = new FormEntityBuilder();
        formEntry.addParameter("_charset_", "utf-8");
        for (Authorizable authorizable : authorizables) {
            formEntry.addParameter("addMembers", Group.encodeURI(authorizable.getId()));
        }
        RequestExecutor exec = this.doPost(formEntry, new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return HttpUtils.getSlingResponseHandler(exec);
    }

    public SlingResponseHandler removeMembers(Authorizable[] authorizables, int ... expectedStatus) throws ClientException {
        if (authorizables == null) {
            throw new IllegalArgumentException("List of authorizables may not be null!");
        }
        FormEntityBuilder formEntry = new FormEntityBuilder();
        formEntry.addParameter("_charset_", "utf-8");
        for (Authorizable authorizable : authorizables) {
            formEntry.addParameter("removeMembers", Group.encodeURI(authorizable.getId()));
        }
        RequestExecutor exec = this.doPost(formEntry, new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return HttpUtils.getSlingResponseHandler(exec);
    }

    public boolean hasGroupMember(Authorizable authorizable) throws ClientException {
        if (authorizable == null) {
            throw new IllegalArgumentException("Authorizable may not be null!");
        }
        return this.getMembers().containsKey(authorizable.getHomePath());
    }

    public static <T extends SecurityClient> Group createGroup(T client, String groupId, String intermediatePath, String givenName, String aboutMe, int ... expectedStatus) throws ClientException {
        if (client == null || groupId == null) {
            throw new IllegalArgumentException("Client and groupId may not be null!");
        }
        FormEntityBuilder feb = new FormEntityBuilder().addParameter("_charset_", "utf-8").addParameter("createGroup", "2").addParameter("authorizableId", groupId);
        if (intermediatePath != null) {
            feb.addParameter("intermediatePath", intermediatePath);
        }
        if (givenName != null) {
            feb.addParameter("./profile/givenName", givenName);
        }
        if (aboutMe != null) {
            feb.addParameter("./profile/aboutMe", aboutMe);
        }
        RequestExecutor exec = client.getManager().doPost(feb, expectedStatus);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(201, expectedStatus));
        String groupPath = Group.buildAuthorizablePath(groupId, ROOT_PATH, intermediatePath);
        return new Group(client, groupId, groupPath);
    }
}

