/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.testing.client.security;

import com.adobe.granite.testing.ClientException;
import com.adobe.granite.testing.client.SecurityClient;
import com.adobe.granite.testing.client.security.AbstractAuthorizable;
import com.adobe.granite.testing.client.security.UserProfile;
import com.adobe.granite.testing.util.FormEntityBuilder;
import com.adobe.granite.testing.util.HttpUtils;
import com.adobe.granite.testing.util.SlingResponseHandler;
import java.util.Map;
import java.util.Set;
import org.apache.sling.testing.tools.http.RequestExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
extends AbstractAuthorizable {
    public static final String ROOT_PATH = "/home/users";
    protected UserProfile profile;

    public <T extends SecurityClient> User(T client, String authorizableId) throws ClientException {
        super(client, authorizableId);
    }

    public <T extends SecurityClient> User(T client, String authorizableId, String authorizablePath) throws ClientException {
        super(client, authorizableId, authorizablePath);
    }

    @Override
    public String getRootPath() {
        return ROOT_PATH;
    }

    public <T extends User> SlingResponseHandler addImpersonators(T[] authorizables, int ... expectedStatus) throws ClientException {
        if (authorizables == null) {
            throw new IllegalArgumentException("List of authorizables may not be null!");
        }
        FormEntityBuilder formEntry = new FormEntityBuilder();
        formEntry.addParameter("_charset_", "utf-8");
        for (T authorizable : authorizables) {
            formEntry.addParameter("addImpersonators", User.encodeURI(((AbstractAuthorizable)authorizable).getId()));
        }
        RequestExecutor exec = this.doPost(formEntry, new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return HttpUtils.getSlingResponseHandler(exec);
    }

    public <T extends User> SlingResponseHandler removeImpersonators(T[] authorizables, int ... expectedStatus) throws ClientException {
        if (authorizables == null) {
            throw new IllegalArgumentException("List of authorizables may not be null!");
        }
        FormEntityBuilder formEntry = new FormEntityBuilder();
        formEntry.addParameter("_charset_", "utf-8");
        for (T authorizable : authorizables) {
            formEntry.addParameter("removeImpersonators", User.encodeURI(((AbstractAuthorizable)authorizable).getId()));
        }
        RequestExecutor exec = this.doPost(formEntry, new int[0]);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(200, expectedStatus));
        return HttpUtils.getSlingResponseHandler(exec);
    }

    public UserProfile getUserProfile() throws ClientException {
        if (this.profile == null) {
            this.initProfile();
        }
        return this.profile;
    }

    protected <T extends SecurityClient> void initProfile() throws ClientException {
        this.profile = new UserProfile(this);
    }

    public static <T extends SecurityClient> User createUser(T client, String userId, String password, String intermediatePath, Map<String, String> profileMap, int ... expectedStatus) throws ClientException {
        if (client == null || userId == null) {
            throw new IllegalArgumentException("Client and userId may not be null!");
        }
        if (password == null) {
            password = userId;
        }
        FormEntityBuilder feb = new FormEntityBuilder();
        feb.addParameter("_charset_", "utf-8");
        feb.addParameter("createUser", "1");
        feb.addParameter("authorizableId", userId);
        feb.addParameter("rep:password", password);
        if (intermediatePath != null) {
            feb.addParameter("intermediatePath", intermediatePath);
        }
        if (profileMap != null) {
            Set<String> profileProps = profileMap.keySet();
            for (String propName : profileProps) {
                String propValue = profileMap.get(propName);
                if (propValue == null) continue;
                feb.addParameter("./profile/" + propName, propValue);
            }
        }
        RequestExecutor exec = client.getManager().doPost(feb, expectedStatus);
        HttpUtils.verifyHttpStatus(exec, HttpUtils.getExpectedStatus(201, expectedStatus));
        String userPath = User.buildAuthorizablePath(userId, ROOT_PATH, intermediatePath);
        return new User(client, userId, userPath);
    }
}

