/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.testing.client.workflow;

import com.adobe.granite.testing.client.WorkflowClient;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowInstance {
    private JsonNode rootNode = null;

    public WorkflowInstance(JsonNode rootNode) {
        this.rootNode = rootNode;
    }

    public String getId() {
        if (this.rootNode.get("id") == null) {
            return null;
        }
        return this.rootNode.get("id").getValueAsText();
    }

    public WorkflowClient.Status getStatus() {
        if (this.rootNode.get("state") == null) {
            return null;
        }
        return WorkflowClient.Status.valueOf(this.rootNode.get("state").getValueAsText());
    }

    public String getModelId() {
        if (this.rootNode.get("model") == null) {
            return null;
        }
        return this.rootNode.get("model").getValueAsText();
    }

    public String getPayloadType() {
        if (this.rootNode.get("payloadType") == null) {
            return null;
        }
        return this.rootNode.get("payloadType").getValueAsText();
    }

    public String getPayload() {
        if (this.rootNode.get("payload") == null) {
            return null;
        }
        return this.rootNode.get("payload").getValueAsText();
    }

    public String getInitiator() {
        if (this.rootNode.get("initiator") == null) {
            return null;
        }
        return this.rootNode.get("initiator").getValueAsText();
    }

    public Date getStartTime() {
        if (this.rootNode.get("startTime") == null) {
            return null;
        }
        return WorkflowClient.parseJSONDate(this.rootNode.get("startTime").getValueAsText());
    }

    public Date getEndTime() {
        if (this.rootNode.get("endTime") == null) {
            return null;
        }
        return WorkflowClient.parseJSONDate(this.rootNode.get("endTime").getValueAsText());
    }

    public List<String> getWorkItemIds() {
        if (this.rootNode.get("workItems") == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        JsonNode itemsNode = this.rootNode.get("workItems");
        for (int i = 0; i < itemsNode.size(); ++i) {
            list.add(itemsNode.get(i).get("id").getValueAsText());
        }
        return list;
    }

    public Map<String, String> getWorkItems() {
        if (this.rootNode.get("workItems") == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        JsonNode itemsNode = this.rootNode.get("workItems");
        for (int i = 0; i < itemsNode.size(); ++i) {
            JsonNode workItem = itemsNode.get(i);
            map.put(workItem.get("id").getValueAsText(), workItem.get("node").getValueAsText());
        }
        return map;
    }
}

