/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.testing.client.workflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jackson.JsonNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowModel {
    private JsonNode rootNode = null;

    public WorkflowModel(JsonNode rootNode) {
        this.rootNode = rootNode;
    }

    public String getId() {
        if (this.rootNode.get("id") == null) {
            return null;
        }
        return this.rootNode.get("id").getValueAsText();
    }

    public String getTitle() {
        if (this.rootNode.get("title") == null) {
            return null;
        }
        return this.rootNode.get("title").getValueAsText();
    }

    public String getDescription() {
        if (this.rootNode.get("description") == null) {
            return null;
        }
        return this.rootNode.get("description").getValueAsText();
    }

    public String getVersion() {
        if (this.rootNode.get("version") == null) {
            return null;
        }
        return this.rootNode.get("version").getValueAsText();
    }

    public int getVersionMajor() {
        if (this.getVersion() == null) {
            return -1;
        }
        return Integer.parseInt(this.getVersion().split("\\.")[0]);
    }

    public int getVersionMinor() {
        if (this.getVersion() == null) {
            return -1;
        }
        return Integer.parseInt(this.getVersion().split("\\.")[1]);
    }

    public Map getMetaData() {
        if (this.rootNode.get("metaData") == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        JsonNode metaData = this.rootNode.get("metaData");
        Iterator it = metaData.getFieldNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            map.put(key, metaData.get(key).getValueAsText());
        }
        return map;
    }

    public Map<String, Node> getNodes() {
        if (this.rootNode.get("nodes") == null) {
            return null;
        }
        HashMap<String, Node> map = new HashMap<String, Node>();
        JsonNode nodes = this.rootNode.get("nodes");
        for (int i = 0; i < nodes.size(); ++i) {
            JsonNode n = nodes.get(i);
            map.put(n.get("id").getValueAsText(), new Node(n));
        }
        return map;
    }

    public Node getNodeById(String nodeId) {
        if (this.rootNode.get("nodes") == null) {
            return null;
        }
        JsonNode nodes = this.rootNode.get("nodes");
        for (int i = 0; i < nodes.size(); ++i) {
            if (!nodes.get(i).get("id").getValueAsText().equals(nodeId)) continue;
            return new Node(nodes.get(i));
        }
        return null;
    }

    public ArrayList<Transition> getTransitions() {
        if (this.rootNode.get("transitions") == null) {
            return null;
        }
        ArrayList<Transition> list = new ArrayList<Transition>();
        JsonNode transitions = this.rootNode.get("transitions");
        for (int i = 0; i < transitions.size(); ++i) {
            list.add(new Transition(transitions.get(i)));
        }
        return list;
    }

    public class Transition {
        private JsonNode transitionNode;

        protected Transition(JsonNode node) {
            this.transitionNode = node;
        }

        public String getFrom() {
            if (this.transitionNode.get("from") == null) {
                return null;
            }
            return this.transitionNode.get("from").getValueAsText();
        }

        public String getTo() {
            if (this.transitionNode.get("to") == null) {
                return null;
            }
            return this.transitionNode.get("to").getValueAsText();
        }

        public String getRule() {
            if (this.transitionNode.get("rule") == null) {
                return null;
            }
            return this.transitionNode.get("rule").getValueAsText();
        }

        public Map getMetaData() {
            if (this.transitionNode.get("metaData") == null) {
                return null;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            JsonNode metaData = this.transitionNode.get("metaData");
            Iterator it = metaData.getFieldNames();
            while (it.hasNext()) {
                String key = (String)it.next();
                map.put(key, metaData.get(key).getValueAsText());
            }
            return map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Node {
        private JsonNode nodeNode = null;

        protected Node(JsonNode node) {
            this.nodeNode = node;
        }

        public String getId() {
            if (this.nodeNode.get("id") == null) {
                return null;
            }
            return this.nodeNode.get("id").getValueAsText();
        }

        public String getType() {
            if (this.nodeNode.get("type") == null) {
                return null;
            }
            return this.nodeNode.get("type").getValueAsText();
        }

        public String getTitle() {
            if (this.nodeNode.get("title") == null) {
                return null;
            }
            return this.nodeNode.get("title").getValueAsText();
        }

        public String getDescription() {
            if (this.nodeNode.get("description") == null) {
                return null;
            }
            return this.nodeNode.get("description").getValueAsText();
        }

        public Map<String, String> getMetaData() {
            if (this.nodeNode.get("metaData") == null) {
                return null;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            JsonNode metaData = this.nodeNode.get("metaData");
            Iterator it = metaData.getFieldNames();
            while (it.hasNext()) {
                String key = (String)it.next();
                map.put(key, metaData.get(key).getValueAsText());
            }
            return map;
        }
    }
}

