/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.testing.json;

import com.adobe.granite.testing.json.SchemaValidationError;
import com.adobe.granite.testing.json.SchemaValidationResult;
import com.adobe.granite.testing.util.ResourceUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JsonSchemaValidator {
    private String validatorCode = ResourceUtil.readResourceAsString("/jsonschema-b4-1.js");

    public SchemaValidationResult validate(String jsonData, String jsonSchemaFile) throws Exception {
        String schema = ResourceUtil.readResourceAsString(jsonSchemaFile);
        String jsCode = this.buildJsCode(this.validatorCode, schema, jsonData);
        String validationResult = this.execute(jsCode);
        return this.getValidationResult(validationResult);
    }

    private SchemaValidationResult getValidationResult(String validationResult) {
        if (validationResult != null && validationResult.length() > 0) {
            if (validationResult.startsWith("true")) {
                return new SchemaValidationResult(true);
            }
            StringTokenizer tokenizer = new StringTokenizer(validationResult, "|");
            ArrayList<SchemaValidationError> validationErrors = new ArrayList<SchemaValidationError>();
            while (tokenizer.hasMoreTokens()) {
                String nextError = tokenizer.nextToken();
                if (nextError.equals("false")) continue;
                validationErrors.add(new SchemaValidationError(nextError));
            }
            return new SchemaValidationResult(false, validationErrors);
        }
        return new SchemaValidationResult(false);
    }

    private String buildJsCode(String validatorCode, String schema, String jsonData) {
        StringBuffer sb = new StringBuffer();
        sb.append(validatorCode);
        sb.append("schema=").append(schema);
        sb.append("data=").append(jsonData).append(";");
        sb.append("result = JSONSchema.validate(data, schema);");
        sb.append("out.print(result['valid']+'|');");
        sb.append("errors = result['errors'];");
        sb.append("for(i=0; i<errors.length; i++){error = errors[i]; out.print('property='+error['property'] + ' message=' + error['message']+'|')};");
        return sb.toString();
    }

    private String execute(String jsCode) throws Exception {
        Context rhinoContext = Context.enter();
        ScriptableObject scope = rhinoContext.initStandardObjects();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        ScriptableObject.putProperty((Scriptable)scope, (String)"out", (Object)Context.javaToJS((Object)pw, (Scriptable)scope));
        boolean lineNumber = true;
        Object securityDomain = null;
        rhinoContext.evaluateString((Scriptable)scope, jsCode, this.getClass().getSimpleName(), 1, securityDomain);
        pw.flush();
        return sw.toString().trim();
    }
}

