/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.testing.util;

import com.adobe.granite.xss.impl.XSSAPIImpl;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringEscapeUtils;

public class GraniteXSSUtils {
    public static String encodeUrl(String urlString) {
        String result = null;
        try {
            result = URLEncoder.encode(urlString, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 not supported", ex);
        }
        return result;
    }

    public static String escapeHtml(String htmlString) {
        return StringEscapeUtils.escapeHtml((String)htmlString);
    }

    public static String escapeXml(String xmlString) {
        String xssString = xmlString;
        if (xmlString != null) {
            xssString = xssString.replace(";", "&#x3b;");
            xssString = xssString.replace(" ", "&#x20;");
            xssString = xssString.replace("'", "&#x27;");
            xssString = xssString.replace("\"", "&quot;");
            xssString = xssString.replace(">", "&gt;");
            xssString = xssString.replace("<", "&lt;");
            xssString = xssString.replace("/", "&#x2f;");
            xssString = xssString.replace("(", "&#x28;");
            xssString = xssString.replace(")", "&#x29;");
            xssString = xssString.replace(":", "&#x3a;");
        }
        return xssString;
    }

    public static String escapeJavaScript(String jsString) {
        return StringEscapeUtils.escapeJavaScript((String)jsString);
    }

    public static String encodeForHTML(String source) {
        XSSAPIImpl xssAPI = new XSSAPIImpl();
        return xssAPI.encodeForHTML(source);
    }

    public static String encodeForHTMLAttr(String source) {
        XSSAPIImpl xssAPI = new XSSAPIImpl();
        return xssAPI.encodeForHTMLAttr(source);
    }

    public static String encodeForXML(String source) {
        XSSAPIImpl xssAPI = new XSSAPIImpl();
        return xssAPI.encodeForXML(source);
    }

    public static String encodeForXMLAttr(String source) {
        XSSAPIImpl xssAPI = new XSSAPIImpl();
        return xssAPI.encodeForXMLAttr(source);
    }

    public static String encodeForJSString(String source) {
        XSSAPIImpl xssAPI = new XSSAPIImpl();
        return xssAPI.encodeForJSString(source);
    }
}

