/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.testing.util;

import com.adobe.granite.testing.ClientException;
import com.adobe.granite.testing.util.SlingResponseHandler;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.sling.testing.tools.http.RequestExecutor;
import org.junit.Assert;

public class HttpUtils {
    public static void verifyHttpStatus(RequestExecutor exec, int ... expectedStatus) throws ClientException {
        HttpUtils.verifyHttpStatus(exec, HttpUtils.buildDefaultErrorMessage(exec), expectedStatus);
    }

    public static void verifyHttpStatus(RequestExecutor exec, String errorMessage, int ... expectedStatus) throws ClientException {
        if (exec == null) {
            throw new NullPointerException("The Request Executor object is null!");
        }
        HttpUtils.verifyHttpStatus(exec.getResponse(), errorMessage, expectedStatus);
    }

    public static void verifyHttpStatus(HttpResponse response, int ... expectedStatus) throws ClientException {
        HttpUtils.verifyHttpStatus(response, null, expectedStatus);
    }

    public static void verifyHttpStatus(HttpResponse response, String errorMessage, int ... expectedStatus) throws ClientException {
        if (response == null) {
            throw new NullPointerException("The HttpResponse object is null!");
        }
        if (expectedStatus == null || expectedStatus.length == 0) {
            throw new IllegalArgumentException("At least one expected HTTP Status must be set!");
        }
        int givenStatus = HttpUtils.getHttpStatus(response);
        for (int expected : expectedStatus) {
            if (givenStatus != expected) continue;
            return;
        }
        String errorMsg = "Expected HTTP Status: ";
        for (int expected : expectedStatus) {
            errorMsg = errorMsg + expected + " ";
        }
        errorMsg = errorMsg + ". Instead " + givenStatus + " was returned!\n";
        if (errorMessage != null) {
            errorMsg = errorMsg + errorMessage;
        }
        throw new ClientException(errorMsg.toString());
    }

    public static void verifyHttpStatusRange(RequestExecutor exec, int ... range) throws ClientException {
        String errorMessage = HttpUtils.buildDefaultErrorMessage(exec);
        for (int expectedRange : range) {
            HttpUtils.verifyHttpStatusRange(exec, errorMessage, expectedRange);
            if (!HttpUtils.isInHttpStatusRange(exec.getResponse(), expectedRange)) continue;
            return;
        }
    }

    public static void verifyHttpStatusRange(RequestExecutor exec, String errorMessage, int range) throws ClientException {
        HttpResponse response = exec.getResponse();
        if (!HttpUtils.isInHttpStatusRange(response, range)) {
            int status = response.getStatusLine().getStatusCode();
            String errorMsg = "Response status not in range. status=" + status + " range=" + range + " " + errorMessage;
            throw new ClientException(errorMsg);
        }
    }

    public static String buildDefaultErrorMessage(RequestExecutor exec) {
        String content = exec.getContent();
        if (content == null) {
            return "";
        }
        SlingResponseHandler slingResponseWrapper = HttpUtils.getSlingResponseHandler(exec);
        String errorMsg = slingResponseWrapper.getMessage();
        errorMsg = errorMsg == null || errorMsg.length() == 0 ? " Response Content:\n" + content : "Error Message: \n" + errorMsg;
        return errorMsg;
    }

    public static SlingResponseHandler getSlingResponseHandler(RequestExecutor exec) {
        return new SlingResponseHandler(exec);
    }

    public static int getHttpStatus(HttpResponse response) throws ClientException {
        return response.getStatusLine().getStatusCode();
    }

    public static String getLocationHeader(HttpResponse response) throws ClientException {
        String location;
        URI locationURI;
        if (response == null) {
            throw new ClientException("Response must not be null!");
        }
        String locationPath = null;
        Header locationHeader = response.getFirstHeader("Location");
        if (locationHeader != null && (locationURI = URI.create(location = locationHeader.getValue())) != null) {
            locationPath = locationURI.getPath();
        }
        if (locationPath == null) {
            Assert.fail((String)"not able to determine location path");
        }
        return locationPath;
    }

    public static boolean isInHttpStatusRange(HttpResponse response, int range) {
        return range == response.getStatusLine().getStatusCode() / 100 * 100;
    }

    public static int[] getExpectedStatus(int defaultStatus, int ... expectedStatus) {
        if (expectedStatus == null || expectedStatus.length == 0) {
            expectedStatus = new int[]{defaultStatus};
        }
        return expectedStatus;
    }
}

