/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.testing.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingParameter {
    private String typeHint = null;
    private boolean delete = false;
    String parameterName;
    private String[] values = null;
    private boolean multiple = false;

    public SlingParameter(String parameterName) {
        if (parameterName == null || parameterName.length() == 0) {
            throw new IllegalArgumentException("parameterName must not be null or empty");
        }
        this.parameterName = parameterName;
    }

    public SlingParameter value(String value) {
        if (value != null) {
            this.values(new String[]{value});
        } else {
            this.values(new String[0]);
        }
        return this;
    }

    public SlingParameter values(String[] values) {
        this.values = values == null ? new String[0] : values;
        return this;
    }

    public SlingParameter typeHint(String typeHint) {
        this.typeHint = typeHint;
        return this;
    }

    public SlingParameter delete() {
        this.delete = true;
        return this;
    }

    public SlingParameter multiple() {
        this.multiple = true;
        return this;
    }

    public List<NameValuePair> toNameValuePairs() {
        String parameter;
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        if (this.multiple) {
            for (String value : this.values) {
                parameters.add((NameValuePair)new BasicNameValuePair(this.parameterName, value));
            }
        } else if (this.values != null && this.values.length == 1) {
            parameters.add((NameValuePair)new BasicNameValuePair(this.parameterName, this.values[0]));
        } else if (this.values != null && this.values.length > 1) {
            parameters.add((NameValuePair)new BasicNameValuePair(this.parameterName, this.values[0]));
        } else {
            parameters.add((NameValuePair)new BasicNameValuePair(this.parameterName, null));
        }
        if (this.typeHint != null) {
            parameter = this.parameterName + "@TypeHint";
            parameters.add((NameValuePair)new BasicNameValuePair(parameter, this.typeHint));
        }
        if (this.delete) {
            parameter = this.parameterName + "@Delete";
            parameters.add((NameValuePair)new BasicNameValuePair(parameter, "true"));
        }
        return parameters;
    }
}

