/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.testing.util;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.sling.testing.tools.http.RequestExecutor;

public class SlingResponseHandler {
    public static final String STATUS = "Status";
    public static final String MESSAGE = "Message";
    public static final String LOCATION = "Location";
    public static final String PARENT_LOCATION = "ParentLocation";
    public static final String PATH = "Path";
    public static final String REFERER = "Referer";
    public static final String CHANGE_LOG = "ChangeLog";
    private String content = null;
    private RequestExecutor requestExecutor = null;

    public SlingResponseHandler(RequestExecutor requestExecutor) {
        if (requestExecutor == null) {
            throw new IllegalArgumentException("RequestExecutor may not be null");
        }
        this.requestExecutor = requestExecutor;
        this.content = requestExecutor.getContent();
    }

    public SlingResponseHandler(String content) {
        if (content == null) {
            throw new IllegalArgumentException("Content may not be null");
        }
        this.requestExecutor = null;
        this.content = content;
    }

    public RequestExecutor getRequestExecutor() {
        if (this.requestExecutor == null) {
            throw new IllegalArgumentException("RequestExecutor is null! SlingResponseHandler was not initialized with a valid RequestExecutor.");
        }
        return this.requestExecutor;
    }

    public String getContent() {
        return this.content;
    }

    public String getStatus() {
        String searchPattern = "id=\"Status\">";
        return this.extractFromHTMLResponse(searchPattern);
    }

    public int getStatusAsInt() throws NumberFormatException {
        String strStatus = this.getStatus();
        return Integer.parseInt(strStatus);
    }

    public String getMessage() {
        String searchPattern = "id=\"Message\">";
        return this.extractFromHTMLResponse(searchPattern);
    }

    public String[] getCopyPaths() {
        String copyPaths = this.getMessage();
        StringTokenizer tokenizer = new StringTokenizer(copyPaths);
        ArrayList<String> copies = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            copies.add(tokenizer.nextToken());
        }
        return copies.toArray(new String[copies.size()]);
    }

    public String getLocation() {
        String searchPattern = "id=\"Location\">";
        return this.extractFromHTMLResponse(searchPattern);
    }

    public String getParentLocation() {
        String searchPattern = "id=\"ParentLocation\">";
        return this.extractFromHTMLResponse(searchPattern);
    }

    public String getPath() {
        String searchPattern = "id=\"Path\">";
        return this.extractFromHTMLResponse(searchPattern);
    }

    public String getReferer() {
        String searchPattern = "id=\"Referer\">";
        return this.extractFromHTMLResponse(searchPattern);
    }

    public String getChangeLog() {
        String searchPattern = "id=\"ChangeLog\">";
        return this.extractFromHTMLResponse(searchPattern);
    }

    protected String extractFromHTMLResponse(String searchPattern) {
        String tmpResponse = null;
        int start = this.getContent().indexOf(searchPattern);
        if (start > 0) {
            tmpResponse = this.getContent().substring(start += searchPattern.length());
            int end = tmpResponse.indexOf("<");
            tmpResponse = tmpResponse.substring(0, end);
        }
        return tmpResponse;
    }
}

