/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.testing.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLParameterBuilder {
    public static final String ENCODING = "UTF-8";
    private List<NameValuePair> params = new ArrayList<NameValuePair>();

    public void add(String name, String value) {
        this.params.add((NameValuePair)new BasicNameValuePair(name, value));
    }

    public void add(NameValuePair pair) {
        this.params.add(pair);
    }

    public void add(List<NameValuePair> list) {
        this.params.addAll(list);
    }

    public void add(String[] list) {
        if (list.length % 2 != 0) {
            throw new IllegalArgumentException("String[] must be an even-sized list of alternating names and values");
        }
        for (int i = 0; i < list.length; i += 2) {
            this.add(list[i], list[i + 1]);
        }
    }

    public void add(String name, String[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.add(name, values[i]);
        }
    }

    public String getURLParameters() {
        return URLEncodedUtils.format(this.params, (String)ENCODING);
    }
}

