/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import com.adobe.granite.xss.XSSAPI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttrBuilder {
    private HttpServletRequest req;
    private XSSAPI xssAPI;
    private Map<String, String> data = new LinkedHashMap<String, String>();
    private Set<String> classes = new HashSet<String>();

    public AttrBuilder(HttpServletRequest req, XSSAPI xssAPI) {
        this.req = req;
        this.xssAPI = xssAPI;
    }

    public void addRel(String value) {
        this.addClass(value);
    }

    public void addClass(String value) {
        if (value == null || value.trim().length() == 0) {
            return;
        }
        if (this.classes.add(value)) {
            this.add("class", value);
        }
    }

    public void addHref(String name, String value) {
        if (value == null || value.trim().length() == 0) {
            return;
        }
        if (value.startsWith("/")) {
            value = this.req.getContextPath() + value;
        }
        this.data.put(name, this.xssAPI.getValidHref(value));
    }

    public void addDisabled(boolean disabled) {
        this.addBoolean("disabled", disabled);
    }

    public void addChecked(boolean checked) {
        this.addBoolean("checked", checked);
    }

    public void addSelected(boolean selected) {
        this.addBoolean("selected", selected);
    }

    public void addMultiple(boolean multiple) {
        this.addBoolean("multiple", multiple);
    }

    public void addBoolean(String name, boolean value) {
        if (!value) {
            return;
        }
        this.add(name, name);
    }

    public void addOther(String name, String value) {
        this.add("data-" + this.xssAPI.encodeForHTML(name), value);
    }

    public void addOthers(Map<String, Object> data, String ... exclusions) {
        List<String> blacklisted = Arrays.asList(exclusions);
        for (Map.Entry<String, Object> e : data.entrySet()) {
            String key = e.getKey();
            if (key.indexOf(":") >= 0 || blacklisted.indexOf(key) >= 0) continue;
            this.addOther(key, e.getValue().toString());
        }
    }

    public void add(String name, Boolean value) {
        if (value == null || name == null || name.trim().length() == 0) {
            return;
        }
        this.addNoCheck(name, value.toString());
    }

    public void add(String name, Integer value) {
        if (value == null || name == null || name.trim().length() == 0) {
            return;
        }
        this.addNoCheck(name, value.toString());
    }

    public void add(String name, Double value) {
        if (value == null || name == null || name.trim().length() == 0) {
            return;
        }
        this.addNoCheck(name, value.toString());
    }

    public void add(String name, String value) {
        if (value == null || name == null || name.trim().length() == 0) {
            return;
        }
        this.addNoCheck(name, this.xssAPI.encodeForHTMLAttr(value));
    }

    public void set(String name, String value) {
        if (value == null || name == null || name.trim().length() == 0) {
            return;
        }
        this.data.put(name, this.xssAPI.encodeForHTMLAttr(value));
    }

    private void addNoCheck(String name, String v) {
        if (this.data.containsKey(name)) {
            v = this.data.get(name) + " " + v;
        }
        this.data.put(name, v);
    }

    public String build() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> e : this.data.entrySet()) {
            sb.append(" " + e.getKey() + "='" + e.getValue() + "'");
        }
        return sb.toString();
    }
}

