/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import java.util.Collections;
import java.util.Iterator;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private Resource resource;
    private Resource parentResource;
    private ValueMap properties;
    private ValueMap defaultProperties;
    private ValueMap parentProperties;
    public static String DEFAULTS = "defaults";
    public static String ITEMS = "items";
    public static String LAYOUT = "layout";

    public Config(Resource resource) {
        this.resource = resource;
        this.properties = ResourceUtil.getValueMap((Resource)resource);
    }

    public Config(Resource resource, boolean buildAll) {
        this.resource = resource;
        this.properties = ResourceUtil.getValueMap((Resource)resource);
        if (buildAll) {
            this.parentResource = this.getParentResource();
            Resource defaults = this.parentResource.getChild(DEFAULTS);
            if (defaults != null) {
                this.defaultProperties = ResourceUtil.getValueMap((Resource)defaults);
            }
            if (this.parentResource != null) {
                this.parentProperties = ResourceUtil.getValueMap((Resource)this.parentResource);
            }
        }
    }

    public Config(Resource resource, ValueMap defaultProperties, ValueMap parentProperties) {
        this.resource = resource;
        this.properties = ResourceUtil.getValueMap((Resource)resource);
        this.defaultProperties = defaultProperties;
        this.parentProperties = parentProperties;
    }

    public String get(String name) {
        return this.get(name, "");
    }

    public <T> T get(String name, T defaultValue) {
        return (T)this.properties.get(name, defaultValue);
    }

    public <T> T get(String name, Class<T> type) {
        return (T)this.properties.get(name, type);
    }

    public String getInherited(String name) {
        return this.getInherited(name, "");
    }

    public <T> T getInherited(String name, T defaultValue) {
        Class<T> type = this.getType(defaultValue);
        T value = this.getInherited(name, type);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public <T> T getInherited(String name, Class<T> type) {
        Object value = this.properties.get(name, type);
        if (value == null && this.parentProperties != null) {
            value = this.parentProperties.get(name, type);
        }
        return (T)value;
    }

    public String getInheritedDefault(String name) {
        return this.getInheritedDefault(name, "");
    }

    public <T> T getInheritedDefault(String name, T defaultValue) {
        Class<T> type = this.getType(defaultValue);
        T value = this.getInheritedDefault(name, type);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public <T> T getInheritedDefault(String name, Class<T> type) {
        Object value = this.properties.get(name, type);
        if (value == null && this.defaultProperties != null) {
            value = this.defaultProperties.get(name, type);
        }
        return (T)value;
    }

    public ValueMap getDefaultProperties() {
        return ResourceUtil.getValueMap((Resource)this.resource.getChild(DEFAULTS));
    }

    public ValueMap getProperties() {
        return this.properties;
    }

    public Iterator<Resource> getItems() {
        return this.getItems(this.resource, ITEMS);
    }

    public Iterator<Resource> getItems(String name) {
        return this.getItems(this.resource, name);
    }

    public Iterator<Resource> getItems(Resource resource) {
        return this.getItems(resource, ITEMS);
    }

    public Iterator<Resource> getItems(Resource resource, String name) {
        Resource items;
        if (name == null || "".equals(name)) {
            name = ITEMS;
        }
        if ((items = resource.getChild(name)) != null) {
            return items.listChildren();
        }
        return Collections.emptyList().iterator();
    }

    public Resource getChild(String name) {
        Resource res = this.resource.getChild(name);
        if (res != null) {
            return res;
        }
        return null;
    }

    public Resource getParentResource() {
        if (this.parentResource != null) {
            return this.parentResource;
        }
        this.parentResource = this.resource.getParent();
        if ("nt:unstructured".equals(this.parentResource.getResourceType())) {
            this.parentResource = this.parentResource.getParent();
        }
        return this.parentResource;
    }

    private <T> Class<T> getType(T defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        return defaultValue.getClass();
    }
}

