/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import com.adobe.granite.i18n.LocaleUtil;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.i18n.I18n;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.servlets.post.AbstractPostResponse;

public class HtmlResponse
extends AbstractPostResponse {
    private static final String PN_DESCRIPTION = "description";
    private final XSSAPI xss;
    private final I18n i18n;
    private final Locale locale;
    private final List<Change> changes = new ArrayList<Change>();
    private final List<Link> links = new ArrayList<Link>();

    public HtmlResponse(XSSAPI xss, I18n i18n, Locale locale) {
        this.xss = xss;
        this.i18n = i18n;
        this.locale = locale;
    }

    public void onModified(String path) {
        this.onChange("^", path);
    }

    public void onCreated(String path) {
        this.onChange("+", path);
    }

    public void onDeleted(String path) {
        if (path != null) {
            this.onChange("-", path);
        }
    }

    public void onMoved(String srcPath, String dstPath) {
        this.onChange(">", srcPath, dstPath);
    }

    public void onCopied(String srcPath, String dstPath) {
        this.onChange("*", srcPath, dstPath);
    }

    public void onChange(String type, String ... arguments) {
        this.changes.add(new Change(type, arguments));
    }

    public void setDescription(String description) {
        this.setProperty(PN_DESCRIPTION, description);
    }

    public void setGeneralError(int code) {
        this.setStatus(code, this.i18n.get("The server has problem processing your request."));
        this.setTitle(this.i18n.get("Error"));
        this.setDescription(this.i18n.get("The server has problem processing your request."));
    }

    public void addRedirectLink(String href, String text) {
        this.addLink("foundation-form-response-redirect", href, text);
    }

    public void addLink(String rel, String href, String text) {
        this.links.add(new Link(rel, href, text));
    }

    protected void doSend(HttpServletResponse res) throws IOException {
        res.setContentType("text/html");
        res.setCharacterEncoding("UTF-8");
        PrintWriter out = res.getWriter();
        ((Writer)out).write("<!DOCTYPE html>\n");
        ((Writer)out).write("<html lang='" + LocaleUtil.toRFC4646((Locale)this.locale) + "'>\n");
        ((Writer)out).write("<head>\n");
        Object title = this.getProperty("title");
        if (title != null) {
            this.write(out, "title", title.toString(), true);
        }
        ((Writer)out).write("</head>\n");
        ((Writer)out).write("<body>\n");
        if (title != null) {
            this.write(out, "h1", title.toString(), true);
        }
        ((Writer)out).write("<dl>\n");
        this.writeDefinition(out, "foundation-form-response-status-code", this.i18n.get("Status"), this.getProperty("status.code"));
        this.writeDefinition(out, "foundation-form-response-status-message", this.i18n.get("Message"), this.getProperty("status.message"));
        this.writeDefinition(out, "foundation-form-response-title", this.i18n.get("Title"), title);
        this.writeDefinition(out, "foundation-form-response-description", this.i18n.get("Description"), this.getProperty(PN_DESCRIPTION));
        if (!this.changes.isEmpty()) {
            ((Writer)out).write("<dt class='foundation-form-response-changelog'>");
            ((Writer)out).write(this.i18n.get("Change Log"));
            ((Writer)out).write("</dt>\n");
            ((Writer)out).write("<dd>\n");
            ((Writer)out).write("<ol>\n");
            for (Change change : this.changes) {
                ((Writer)out).write("<li>");
                this.writeChange(out, change);
                ((Writer)out).write("</li>\n");
            }
            ((Writer)out).write("</ol>\n");
            ((Writer)out).write("</dd>\n");
        }
        ((Writer)out).write("</dl>\n");
        if (!this.links.isEmpty()) {
            this.write(out, "h2", this.i18n.get("Links"), true);
            ((Writer)out).write("<ul class='foundation-form-response-links'>\n");
            for (Link link : this.links) {
                ((Writer)out).write("<li>");
                this.writeLink(out, link);
                ((Writer)out).write("</li>\n");
            }
            ((Writer)out).write("</ul>\n");
        }
        ((Writer)out).write("</body>\n");
        ((Writer)out).write("</html>\n");
    }

    private void writeDefinition(Writer out, String rel, String term, Object value) throws IOException {
        if (value == null) {
            return;
        }
        out.write("<dt class='" + this.xss.encodeForHTMLAttr(rel) + "'>");
        out.write(this.xss.encodeForHTML(term));
        out.write("</dt>\n");
        out.write("<dd>");
        out.write(this.xss.filterHTML(value.toString()));
        out.write("</dd>\n");
    }

    private void writeChange(Writer out, Change change) throws IOException {
        this.write(out, "span", change.type, false);
        out.write("(");
        for (int i = 0; i < change.arguments.length; ++i) {
            if (i > 0) {
                out.write(", ");
            }
            this.write(out, "span", change.arguments[i], false);
        }
        out.write(")");
    }

    private void writeLink(Writer out, Link link) throws IOException {
        out.write("<a class='" + this.xss.encodeForHTMLAttr(link.rel) + "' href='" + this.xss.getValidHref(link.href) + "'>");
        out.write(this.xss.encodeForHTML(link.text));
        out.write("</a>");
    }

    private void write(Writer out, String tag, String text, boolean newline) throws IOException {
        out.write("<" + tag + ">" + this.xss.encodeForHTML(text) + "</" + tag + ">");
        if (newline) {
            out.write("\n");
        }
    }

    private class Link {
        String rel;
        String href;
        String text;

        public Link(String rel, String href, String text) {
            this.rel = rel;
            this.href = href;
            this.text = text;
        }
    }

    private class Change {
        String type;
        String[] arguments;

        public Change(String type, String ... arguments) {
            this.type = type;
            this.arguments = arguments;
        }
    }
}

