/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import com.adobe.granite.ui.components.Config;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Value {
    private SlingHttpServletRequest slingRequest;
    private Resource contentResource;
    private ValueMap values = null;
    private Config config;
    public static String CONTENTPATH_ATTRIBUTE = "granite.ui.form.contentpath";

    public Value(SlingHttpServletRequest slingRequest, Config config) {
        this.slingRequest = slingRequest;
        this.config = config;
        String contentPath = (String)slingRequest.getAttribute(CONTENTPATH_ATTRIBUTE);
        if (contentPath != null) {
            this.contentResource = slingRequest.getResourceResolver().resolve(contentPath);
            if (!ResourceUtil.isNonExistingResource((Resource)this.contentResource)) {
                this.values = ResourceUtil.getValueMap((Resource)this.contentResource);
            }
        }
    }

    public String get(String name) {
        return this.get(name, "");
    }

    public <T> T get(String name, T defaultValue) {
        Class<T> type = this.getType(defaultValue);
        T value = this.get(name, type);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public <T> T get(String name, Class<T> type) {
        if (this.values == null || this.config.get("ignoreData", false).booleanValue()) {
            return this.config.get("value", type);
        }
        if (name != null) {
            return (T)this.values.get(name, type);
        }
        return null;
    }

    public String getContentValue(String name) {
        return this.getContentValue(name, "");
    }

    public <T> T getContentValue(String name, T defaultValue) {
        Class<T> type = this.getType(defaultValue);
        T value = this.getContentValue(name, type);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public <T> T getContentValue(String name, Class<T> type) {
        if (this.values != null && name != null) {
            return (T)this.values.get(name, type);
        }
        return null;
    }

    private <T> Class<T> getType(T defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        return defaultValue.getClass();
    }
}

