/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.theme.impl;

import com.day.cq.theme.Theme;
import com.day.cq.theme.ThemeRegistration;
import com.day.cq.theme.ThemeResolver;
import java.util.Dictionary;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingException;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="%defaultthemeresolver.name", description="%defaultthemeresolver.description")
@Service(value={ThemeResolver.class})
public class DefaultThemeResolver
implements ThemeResolver {
    @Reference
    private ThemeRegistration themeRegistration;
    private Filter[] filter;
    private Theme defaultTheme;
    private static final Logger log = LoggerFactory.getLogger(DefaultThemeResolver.class);
    @Property(value={"/content/playground*@/apps/day/themes/blue", "/content/*@/etc/themes/default"})
    private static final String MAPPINGS = "defaultthemeresolver.mapping";
    @Property(value={"/etc/designs/default"})
    private static final String DEFAULT_THEME = "defaultthemeresolver.default";

    public Theme resolveTheme(ServletRequest request) {
        if (!(request instanceof HttpServletRequest)) {
            log.debug("ThemeResolver does not handle requests of Type {} -> no theme assigned", (Object)request.getClass().getName());
            return null;
        }
        try {
            String id = this.getThemeId((HttpServletRequest)request);
            Theme theme = this.getTheme(id);
            if (theme == null && this.defaultTheme != null) {
                theme = this.defaultTheme;
                log.debug("could not resolve Theme with id {} -> use default", (Object)id);
            }
            return theme;
        }
        catch (SlingException e) {
            log.error("could not resolve Theme for {}: {} -> use default", (Object)request, (Object)e.getMessage());
            Theme theme = this.defaultTheme;
            return theme;
        }
    }

    @Activate
    protected void activate(ComponentContext context) {
        Dictionary props = context.getProperties();
        String[] mappings = (String[])props.get(MAPPINGS);
        this.filter = new Filter[mappings.length];
        for (int i = 0; i < mappings.length; ++i) {
            this.filter[i] = new Filter(mappings[i]);
            log.debug("register Filter ''{}''", (Object[])this.filter);
        }
        if (this.themeRegistration == null) {
            throw new IllegalStateException("SCR: missed to set mandatory ThemeRegistration");
        }
        this.defaultTheme = this.themeRegistration.getTheme((String)props.get(DEFAULT_THEME));
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.filter = null;
        this.themeRegistration = null;
        this.defaultTheme = null;
    }

    private Theme getTheme(String themeId) {
        return themeId == null ? this.defaultTheme : this.themeRegistration.getTheme(themeId);
    }

    private String getThemeId(HttpServletRequest request) {
        String uri = request.getRequestURI();
        for (Filter filter : this.filter) {
            if (!filter.handles(uri)) continue;
            return filter.getName();
        }
        return null;
    }

    protected void bindThemeRegistration(ThemeRegistration themeRegistration) {
        this.themeRegistration = themeRegistration;
    }

    protected void unbindThemeRegistration(ThemeRegistration themeRegistration) {
        if (this.themeRegistration == themeRegistration) {
            this.themeRegistration = null;
        }
    }

    private static class Filter {
        private final String name;
        private final String glob;

        Filter(String def) {
            int idx = def.indexOf("@");
            if (idx < 0) {
                this.name = def;
                this.glob = "*";
            } else {
                this.glob = def.substring(0, idx);
                this.name = def.substring(idx + 1);
            }
        }

        boolean handles(String handle) {
            if (this.glob.equals("*")) {
                return true;
            }
            if (handle.equals(this.glob)) {
                return true;
            }
            return handle.startsWith(this.glob + '/');
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "Filter for " + this.name + " with " + this.glob;
        }
    }
}

