/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.theme.impl;

import com.day.cq.theme.Theme;
import com.day.cq.theme.ThemeResolver;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;

@Component(metatype=false)
@Service(value={Filter.class})
@Properties(value={@Property(name="filter.scope", value={"request"}, propertyPrivate=true), @Property(name="filter.order", intValue={-600}, propertyPrivate=true)})
public class ThemeResolverFilter
implements Filter {
    @Reference
    private ThemeResolver themeResolver = null;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        ThemeResolver localTR = this.themeResolver;
        if (localTR != null) {
            Theme theme = localTR.resolveTheme(request);
            request.setAttribute(Theme.REQUEST_ATTR, (Object)theme);
        }
        filterChain.doFilter(request, response);
    }

    public void init(FilterConfig config) {
    }

    public void destroy() {
    }

    protected void bindThemeResolver(ThemeResolver themeResolver) {
        this.themeResolver = themeResolver;
    }

    protected void unbindThemeResolver(ThemeResolver themeResolver) {
        if (this.themeResolver == themeResolver) {
            this.themeResolver = null;
        }
    }
}

