/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.widget.impl;

import com.day.cq.widget.LibraryType;
import com.day.cq.widget.impl.AbstractBuilder;
import com.day.cq.widget.impl.Resource;
import com.day.text.Text;
import com.yahoo.platform.yui.compressor.CssCompressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Binary;
import javax.jcr.Property;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssFileBuilder
extends AbstractBuilder {
    private static final Logger log = LoggerFactory.getLogger(CssFileBuilder.class);
    private static Pattern SCHEME_START = Pattern.compile("^[^:/]+:[^/]*/.*");
    private static Pattern URL_PATTERN = Pattern.compile("url\\(\\s*(['\"]?)([^'\")]*)(['\"]?\\s*)\\)");
    private static final int lineBreakPos = 0;
    private String[] libPath;
    private Session session;
    private long maxDataUriSize;

    public CssFileBuilder(String libraryPath, Session session, long maxDataUriSize) {
        this.libPath = Text.explode((String)libraryPath, (int)47);
        this.session = session;
        this.maxDataUriSize = maxDataUriSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String concatenate(Collection<Resource> resources) throws IOException {
        StringBuilder out = new StringBuilder();
        for (Resource resource : resources) {
            String src;
            Reader r = resource.getReader();
            try {
                src = IOUtils.toString((Reader)r);
            }
            finally {
                IOUtils.closeQuietly((Reader)r);
            }
            String[] filePath = Text.explode((String)resource.getName(), (int)47);
            out.append(CssFileBuilder.rewriteUrlsInCss(this.libPath, filePath, src, this.session, this.maxDataUriSize));
            out.append("\n");
        }
        return out.toString();
    }

    @Override
    protected String minify(String source) throws IOException {
        CssCompressor compressor = new CssCompressor((Reader)new StringReader(source));
        StringWriter out = new StringWriter();
        compressor.compress((Writer)out, 0);
        return out.toString();
    }

    @Override
    public LibraryType getType() {
        return LibraryType.CSS;
    }

    public static String rewriteUrlsInCss(String libPath, String filePath, String css) {
        return CssFileBuilder.rewriteUrlsInCss(Text.explode((String)libPath, (int)47), Text.explode((String)filePath, (int)47), css, null, 0L);
    }

    public static String rewriteUrlsInCss(String libPath, String filePath, String css, Session session, long maxDataUriSize) {
        return CssFileBuilder.rewriteUrlsInCss(Text.explode((String)libPath, (int)47), Text.explode((String)filePath, (int)47), css, session, maxDataUriSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String rewriteUrlsInCss(String[] libPath, String[] filePath, String css, Session session, long maxDataUriSize) {
        Matcher m = URL_PATTERN.matcher(css);
        StringBuffer result = new StringBuffer();
        while (m.find()) {
            String url = m.group(2);
            if (url.startsWith("absolute:")) {
                url = url.substring(9);
            } else {
                url = CssFileBuilder.resolveUrl(libPath, filePath, url);
                if (maxDataUriSize > 0L && session != null && !SCHEME_START.matcher(url).matches()) {
                    Binary bin = null;
                    String path = "/" + Text.implode((String[])libPath, (String)"/") + "/../" + url + "/jcr:content/jcr:data";
                    try {
                        Property p;
                        if (session.propertyExists(path) && (p = session.getProperty(path)).getLength() < maxDataUriSize) {
                            bin = p.getBinary();
                            StringWriter w = new StringWriter();
                            Base64.encode((InputStream)bin.getStream(), (Writer)w);
                            url = "data:" + p.getParent().getProperty("{http://www.jcp.org/jcr/1.0}mimeType").getString() + ";base64," + w.toString();
                        }
                    }
                    catch (Exception e) {
                        log.warn("Error while encoding data uri of {}: {}", (Object)path, (Object)e.toString());
                    }
                    finally {
                        if (bin != null) {
                            bin.dispose();
                        }
                    }
                }
            }
            m.appendReplacement(result, "url($1" + url + "$3)");
        }
        m.appendTail(result);
        return result.toString();
    }

    public static String resolveUrl(String libPath, String filePath, String url) {
        return CssFileBuilder.resolveUrl(Text.explode((String)libPath, (int)47), Text.explode((String)filePath, (int)47), url);
    }

    private static String resolveUrl(String[] libPath, String[] filePath, String url) {
        int i;
        if (url.length() == 0 || SCHEME_START.matcher(url).matches()) {
            if (log.isDebugEnabled()) {
                log.debug("resolving lib=/{}, file=/{}, url={} (ignored)", new Object[]{Text.implode((String[])libPath, (String)"/"), Text.implode((String[])filePath, (String)"/"), url});
            }
            return url;
        }
        LinkedList<String> file = new LinkedList<String>();
        if (!url.startsWith("/")) {
            file.addAll(Arrays.asList(filePath));
            file.removeLast();
        }
        boolean warned = false;
        for (String seg : Text.explode((String)url, (int)47)) {
            if ("..".equals(seg)) {
                if (file.isEmpty()) {
                    if (warned) continue;
                    log.warn("/{}: url('{}') invalid. too many '..'", (Object)Text.implode((String[])filePath, (String)"/"), (Object)url);
                    warned = true;
                    continue;
                }
                file.removeLast();
                continue;
            }
            if (".".equals(seg)) continue;
            file.add(seg);
        }
        for (i = 0; i < libPath.length - 1 && libPath[i].matches((String)file.getFirst()); ++i) {
            file.removeFirst();
        }
        while (i++ < libPath.length - 1) {
            file.addFirst("..");
        }
        StringBuilder ret = new StringBuilder();
        String delim = "";
        for (String seg : file) {
            ret.append(delim).append(seg);
            delim = "/";
        }
        if (log.isDebugEnabled()) {
            log.debug("resolving lib=/{}, file=/{}, url={} -> {}", new Object[]{Text.implode((String[])libPath, (String)"/"), Text.implode((String[])filePath, (String)"/"), url, ret});
        }
        return ret.toString();
    }
}

